/*
 * Decompiled with CFR 0.152.
 */
package com.hiddenlayer.api.core;

import com.fasterxml.jackson.databind.json.JsonMapper;
import com.hiddenlayer.api.core.Check;
import com.hiddenlayer.api.core.DefaultSleeper;
import com.hiddenlayer.api.core.ObjectMappers;
import com.hiddenlayer.api.core.PhantomReachableExecutorService;
import com.hiddenlayer.api.core.PhantomReachableSleeper;
import com.hiddenlayer.api.core.Properties;
import com.hiddenlayer.api.core.Sleeper;
import com.hiddenlayer.api.core.Timeout;
import com.hiddenlayer.api.core.http.Headers;
import com.hiddenlayer.api.core.http.HttpClient;
import com.hiddenlayer.api.core.http.OAuth2HttpClient;
import com.hiddenlayer.api.core.http.PhantomReachableClosingHttpClient;
import com.hiddenlayer.api.core.http.QueryParams;
import com.hiddenlayer.api.core.http.RetryingHttpClient;
import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0002-.B\u008f\u0001\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0006\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100(J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100(J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100(J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020,R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u001eR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00020\u000e8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u001fR\u0013\u0010\u0011\u001a\u00020\u00128\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010 R\u0013\u0010\u0004\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010!R\u0013\u0010\u0007\u001a\u00020\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\"R\u0013\u0010\u0018\u001a\u00020\u00198\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00020\u00148\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010$R\u0013\u0010\u0015\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u001eR\u0013\u0010\u000b\u001a\u00020\f8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010%R\u0013\u0010\t\u001a\u00020\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010&R\u0013\u0010\u0016\u001a\u00020\u00178\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010'\u00a8\u0006/"}, d2={"Lcom/hiddenlayer/api/core/ClientOptions;", "", "originalHttpClient", "Lcom/hiddenlayer/api/core/http/HttpClient;", "httpClient", "checkJacksonVersionCompatibility", "", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "streamHandlerExecutor", "Ljava/util/concurrent/Executor;", "sleeper", "Lcom/hiddenlayer/api/core/Sleeper;", "clock", "Ljava/time/Clock;", "baseUrl", "", "headers", "Lcom/hiddenlayer/api/core/http/Headers;", "queryParams", "Lcom/hiddenlayer/api/core/http/QueryParams;", "responseValidation", "timeout", "Lcom/hiddenlayer/api/core/Timeout;", "maxRetries", "", "bearerToken", "clientId", "clientSecret", "(Lcom/hiddenlayer/api/core/http/HttpClient;Lcom/hiddenlayer/api/core/http/HttpClient;ZLcom/fasterxml/jackson/databind/json/JsonMapper;Ljava/util/concurrent/Executor;Lcom/hiddenlayer/api/core/Sleeper;Ljava/time/Clock;Ljava/lang/String;Lcom/hiddenlayer/api/core/http/Headers;Lcom/hiddenlayer/api/core/http/QueryParams;ZLcom/hiddenlayer/api/core/Timeout;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "()Z", "()Ljava/time/Clock;", "()Lcom/hiddenlayer/api/core/http/Headers;", "()Lcom/hiddenlayer/api/core/http/HttpClient;", "()Lcom/fasterxml/jackson/databind/json/JsonMapper;", "()I", "()Lcom/hiddenlayer/api/core/http/QueryParams;", "()Lcom/hiddenlayer/api/core/Sleeper;", "()Ljava/util/concurrent/Executor;", "()Lcom/hiddenlayer/api/core/Timeout;", "Ljava/util/Optional;", "close", "", "toBuilder", "Lcom/hiddenlayer/api/core/ClientOptions$Builder;", "Builder", "Companion", "hiddenlayer-java-core"})
public final class ClientOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpClient originalHttpClient;
    @NotNull
    private final HttpClient httpClient;
    private final boolean checkJacksonVersionCompatibility;
    @NotNull
    private final JsonMapper jsonMapper;
    @NotNull
    private final Executor streamHandlerExecutor;
    @NotNull
    private final Sleeper sleeper;
    @NotNull
    private final Clock clock;
    @Nullable
    private final String baseUrl;
    @NotNull
    private final Headers headers;
    @NotNull
    private final QueryParams queryParams;
    private final boolean responseValidation;
    @NotNull
    private final Timeout timeout;
    private final int maxRetries;
    @Nullable
    private final String bearerToken;
    @Nullable
    private final String clientId;
    @Nullable
    private final String clientSecret;
    @NotNull
    public static final String PROD_US_URL = "https://api.hiddenlayer.ai";
    @NotNull
    public static final String PROD_EU_URL = "https://api.eu.hiddenlayer.ai";

    private ClientOptions(HttpClient originalHttpClient, HttpClient httpClient, boolean checkJacksonVersionCompatibility2, JsonMapper jsonMapper, Executor streamHandlerExecutor2, Sleeper sleeper, Clock clock, String baseUrl, Headers headers, QueryParams queryParams, boolean responseValidation, Timeout timeout, int maxRetries, String bearerToken, String clientId, String clientSecret) {
        this.originalHttpClient = originalHttpClient;
        this.httpClient = httpClient;
        this.checkJacksonVersionCompatibility = checkJacksonVersionCompatibility2;
        this.jsonMapper = jsonMapper;
        this.streamHandlerExecutor = streamHandlerExecutor2;
        this.sleeper = sleeper;
        this.clock = clock;
        this.baseUrl = baseUrl;
        this.headers = headers;
        this.queryParams = queryParams;
        this.responseValidation = responseValidation;
        this.timeout = timeout;
        this.maxRetries = maxRetries;
        this.bearerToken = bearerToken;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        if (this.checkJacksonVersionCompatibility) {
            Check.checkJacksonVersionCompatibility();
        }
    }

    @JvmName(name="httpClient")
    @NotNull
    public final HttpClient httpClient() {
        return this.httpClient;
    }

    @JvmName(name="checkJacksonVersionCompatibility")
    public final boolean checkJacksonVersionCompatibility() {
        return this.checkJacksonVersionCompatibility;
    }

    @JvmName(name="jsonMapper")
    @NotNull
    public final JsonMapper jsonMapper() {
        return this.jsonMapper;
    }

    @JvmName(name="streamHandlerExecutor")
    @NotNull
    public final Executor streamHandlerExecutor() {
        return this.streamHandlerExecutor;
    }

    @JvmName(name="sleeper")
    @NotNull
    public final Sleeper sleeper() {
        return this.sleeper;
    }

    @JvmName(name="clock")
    @NotNull
    public final Clock clock() {
        return this.clock;
    }

    @JvmName(name="headers")
    @NotNull
    public final Headers headers() {
        return this.headers;
    }

    @JvmName(name="queryParams")
    @NotNull
    public final QueryParams queryParams() {
        return this.queryParams;
    }

    @JvmName(name="responseValidation")
    public final boolean responseValidation() {
        return this.responseValidation;
    }

    @JvmName(name="timeout")
    @NotNull
    public final Timeout timeout() {
        return this.timeout;
    }

    @JvmName(name="maxRetries")
    public final int maxRetries() {
        return this.maxRetries;
    }

    @NotNull
    public final String baseUrl() {
        String string = this.baseUrl;
        if (string == null) {
            string = PROD_US_URL;
        }
        return string;
    }

    @NotNull
    public final Optional<String> bearerToken() {
        Optional<String> optional = Optional.ofNullable(this.bearerToken);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(bearerToken)");
        return optional;
    }

    @NotNull
    public final Optional<String> clientId() {
        Optional<String> optional = Optional.ofNullable(this.clientId);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(clientId)");
        return optional;
    }

    @NotNull
    public final Optional<String> clientSecret() {
        Optional<String> optional = Optional.ofNullable(this.clientSecret);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(clientSecret)");
        return optional;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder().from$hiddenlayer_java_core(this);
    }

    public final void close() {
        this.httpClient.close();
        Executor executor = this.streamHandlerExecutor;
        ExecutorService executorService = executor instanceof ExecutorService ? (ExecutorService)executor : null;
        if (executorService != null) {
            executorService.shutdown();
        }
        this.sleeper.close();
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @JvmStatic
    @NotNull
    public static final ClientOptions fromEnv() {
        return Companion.fromEnv();
    }

    public /* synthetic */ ClientOptions(HttpClient originalHttpClient, HttpClient httpClient, boolean checkJacksonVersionCompatibility2, JsonMapper jsonMapper, Executor streamHandlerExecutor2, Sleeper sleeper, Clock clock, String baseUrl, Headers headers, QueryParams queryParams, boolean responseValidation, Timeout timeout, int maxRetries, String bearerToken, String clientId, String clientSecret, DefaultConstructorMarker $constructor_marker) {
        this(originalHttpClient, httpClient, checkJacksonVersionCompatibility2, jsonMapper, streamHandlerExecutor2, sleeper, clock, baseUrl, headers, queryParams, responseValidation, timeout, maxRetries, bearerToken, clientId, clientSecret);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u001dJ\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0014\u0010\u0005\u001a\u00020\u00002\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u001dJ\u0010\u0010\u0005\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u00020\u00002\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001dJ\u0010\u0010\b\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0004J\u0014\u0010\t\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u001dJ\u0010\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0015\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b\"J\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020$J \u0010\f\u001a\u00020\u00002\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040&0%J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010'\u001a\u00020\u0000J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020$J \u0010(\u001a\u00020\u00002\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040&0%J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020*J \u0010)\u001a\u00020\u00002\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040&0%J\u0016\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004J\u001c\u0010.\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00042\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040&J\u0016\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004J\u001c\u00102\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u00042\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040&J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020*J \u0010\u0014\u001a\u00020\u00002\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040&0%J\u0014\u00103\u001a\u00020\u00002\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000405J\u0014\u00106\u001a\u00020\u00002\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000405J\u000e\u00108\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0004J\u000e\u00109\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0004J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020$J \u0010:\u001a\u00020\u00002\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040&0%J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020*J \u0010;\u001a\u00020\u00002\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040&0%J\u0016\u0010<\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004J\u001c\u0010<\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00042\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040&J\u0016\u0010=\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004J\u001c\u0010=\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u00042\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040&J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020>R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/hiddenlayer/api/core/ClientOptions$Builder;", "", "()V", "baseUrl", "", "bearerToken", "checkJacksonVersionCompatibility", "", "clientId", "clientSecret", "clock", "Ljava/time/Clock;", "headers", "Lcom/hiddenlayer/api/core/http/Headers$Builder;", "httpClient", "Lcom/hiddenlayer/api/core/http/HttpClient;", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "maxRetries", "", "queryParams", "Lcom/hiddenlayer/api/core/http/QueryParams$Builder;", "responseValidation", "sleeper", "Lcom/hiddenlayer/api/core/Sleeper;", "streamHandlerExecutor", "Ljava/util/concurrent/Executor;", "timeout", "Lcom/hiddenlayer/api/core/Timeout;", "Ljava/util/Optional;", "build", "Lcom/hiddenlayer/api/core/ClientOptions;", "from", "clientOptions", "from$hiddenlayer_java_core", "fromEnv", "Lcom/hiddenlayer/api/core/http/Headers;", "", "", "prodEu", "putAllHeaders", "putAllQueryParams", "Lcom/hiddenlayer/api/core/http/QueryParams;", "putHeader", "name", "value", "putHeaders", "values", "putQueryParam", "key", "putQueryParams", "removeAllHeaders", "names", "", "removeAllQueryParams", "keys", "removeHeaders", "removeQueryParams", "replaceAllHeaders", "replaceAllQueryParams", "replaceHeaders", "replaceQueryParams", "Ljava/time/Duration;", "hiddenlayer-java-core"})
    @SourceDebugExtension(value={"SMAP\nClientOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientOptions.kt\ncom/hiddenlayer/api/core/ClientOptions$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,556:1\n1#2:557\n*E\n"})
    public static final class Builder {
        @Nullable
        private HttpClient httpClient;
        private boolean checkJacksonVersionCompatibility = true;
        @NotNull
        private JsonMapper jsonMapper = ObjectMappers.jsonMapper();
        @Nullable
        private Executor streamHandlerExecutor;
        @Nullable
        private Sleeper sleeper;
        @NotNull
        private Clock clock;
        @Nullable
        private String baseUrl;
        @NotNull
        private Headers.Builder headers;
        @NotNull
        private QueryParams.Builder queryParams;
        private boolean responseValidation;
        @NotNull
        private Timeout timeout;
        private int maxRetries;
        @Nullable
        private String bearerToken;
        @Nullable
        private String clientId;
        @Nullable
        private String clientSecret;

        public Builder() {
            Clock clock = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemUTC()");
            this.clock = clock;
            this.headers = Headers.Companion.builder();
            this.queryParams = QueryParams.Companion.builder();
            this.timeout = Timeout.Companion.default();
            this.maxRetries = 2;
        }

        public final /* synthetic */ Builder from$hiddenlayer_java_core(ClientOptions clientOptions) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
            Builder $this$from_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$from_u24lambda_u240.httpClient = clientOptions.originalHttpClient;
            $this$from_u24lambda_u240.checkJacksonVersionCompatibility = clientOptions.checkJacksonVersionCompatibility();
            $this$from_u24lambda_u240.jsonMapper = clientOptions.jsonMapper();
            $this$from_u24lambda_u240.streamHandlerExecutor = clientOptions.streamHandlerExecutor();
            $this$from_u24lambda_u240.sleeper = clientOptions.sleeper();
            $this$from_u24lambda_u240.clock = clientOptions.clock();
            $this$from_u24lambda_u240.baseUrl = clientOptions.baseUrl;
            $this$from_u24lambda_u240.headers = clientOptions.headers().toBuilder();
            $this$from_u24lambda_u240.queryParams = clientOptions.queryParams().toBuilder();
            $this$from_u24lambda_u240.responseValidation = clientOptions.responseValidation();
            $this$from_u24lambda_u240.timeout = clientOptions.timeout();
            $this$from_u24lambda_u240.maxRetries = clientOptions.maxRetries();
            $this$from_u24lambda_u240.bearerToken = clientOptions.bearerToken;
            $this$from_u24lambda_u240.clientId = clientOptions.clientId;
            $this$from_u24lambda_u240.clientSecret = clientOptions.clientSecret;
            return builder;
        }

        @NotNull
        public final Builder httpClient(@NotNull HttpClient httpClient) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
            Builder $this$httpClient_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$httpClient_u24lambda_u241.httpClient = new PhantomReachableClosingHttpClient(httpClient);
            return builder;
        }

        @NotNull
        public final Builder checkJacksonVersionCompatibility(boolean checkJacksonVersionCompatibility2) {
            Builder builder;
            Builder $this$checkJacksonVersionCompatibility_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$checkJacksonVersionCompatibility_u24lambda_u242.checkJacksonVersionCompatibility = checkJacksonVersionCompatibility2;
            return builder;
        }

        @NotNull
        public final Builder jsonMapper(@NotNull JsonMapper jsonMapper) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
            Builder $this$jsonMapper_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$jsonMapper_u24lambda_u243.jsonMapper = jsonMapper;
            return builder;
        }

        @NotNull
        public final Builder streamHandlerExecutor(@NotNull Executor streamHandlerExecutor2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)streamHandlerExecutor2, (String)"streamHandlerExecutor");
            Builder $this$streamHandlerExecutor_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$streamHandlerExecutor_u24lambda_u244.streamHandlerExecutor = streamHandlerExecutor2 instanceof ExecutorService ? (Executor)new PhantomReachableExecutorService((ExecutorService)streamHandlerExecutor2) : streamHandlerExecutor2;
            return builder;
        }

        @NotNull
        public final Builder sleeper(@NotNull Sleeper sleeper) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)sleeper, (String)"sleeper");
            Builder $this$sleeper_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$sleeper_u24lambda_u245.sleeper = new PhantomReachableSleeper(sleeper);
            return builder;
        }

        @NotNull
        public final Builder clock(@NotNull Clock clock) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            Builder $this$clock_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$clock_u24lambda_u246.clock = clock;
            return builder;
        }

        @NotNull
        public final Builder baseUrl(@Nullable String baseUrl) {
            Builder builder;
            Builder $this$baseUrl_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$baseUrl_u24lambda_u247.baseUrl = baseUrl;
            return builder;
        }

        @NotNull
        public final Builder baseUrl(@NotNull Optional<String> baseUrl) {
            Intrinsics.checkNotNullParameter(baseUrl, (String)"baseUrl");
            return this.baseUrl((String)OptionalsKt.getOrNull(baseUrl));
        }

        @NotNull
        public final Builder prodEu() {
            return this.baseUrl(ClientOptions.PROD_EU_URL);
        }

        @NotNull
        public final Builder responseValidation(boolean responseValidation) {
            Builder builder;
            Builder $this$responseValidation_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$responseValidation_u24lambda_u248.responseValidation = responseValidation;
            return builder;
        }

        @NotNull
        public final Builder timeout(@NotNull Timeout timeout) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
            Builder $this$timeout_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$timeout_u24lambda_u249.timeout = timeout;
            return builder;
        }

        @NotNull
        public final Builder timeout(@NotNull Duration timeout) {
            Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
            return this.timeout(Timeout.Companion.builder().request(timeout).build());
        }

        @NotNull
        public final Builder maxRetries(int maxRetries) {
            Builder builder;
            Builder $this$maxRetries_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$maxRetries_u24lambda_u2410.maxRetries = maxRetries;
            return builder;
        }

        @NotNull
        public final Builder bearerToken(@Nullable String bearerToken) {
            Builder builder;
            Builder $this$bearerToken_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$bearerToken_u24lambda_u2411.bearerToken = bearerToken;
            return builder;
        }

        @NotNull
        public final Builder bearerToken(@NotNull Optional<String> bearerToken) {
            Intrinsics.checkNotNullParameter(bearerToken, (String)"bearerToken");
            return this.bearerToken((String)OptionalsKt.getOrNull(bearerToken));
        }

        @NotNull
        public final Builder clientId(@Nullable String clientId) {
            Builder builder;
            Builder $this$clientId_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$clientId_u24lambda_u2412.clientId = clientId;
            return builder;
        }

        @NotNull
        public final Builder clientId(@NotNull Optional<String> clientId) {
            Intrinsics.checkNotNullParameter(clientId, (String)"clientId");
            return this.clientId((String)OptionalsKt.getOrNull(clientId));
        }

        @NotNull
        public final Builder clientSecret(@Nullable String clientSecret) {
            Builder builder;
            Builder $this$clientSecret_u24lambda_u2413 = builder = this;
            boolean bl = false;
            $this$clientSecret_u24lambda_u2413.clientSecret = clientSecret;
            return builder;
        }

        @NotNull
        public final Builder clientSecret(@NotNull Optional<String> clientSecret) {
            Intrinsics.checkNotNullParameter(clientSecret, (String)"clientSecret");
            return this.clientSecret((String)OptionalsKt.getOrNull(clientSecret));
        }

        @NotNull
        public final Builder headers(@NotNull Headers headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder $this$headers_u24lambda_u2414 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u2414.headers.clear();
            $this$headers_u24lambda_u2414.putAllHeaders(headers);
            return builder;
        }

        @NotNull
        public final Builder headers(@NotNull Map<String, ? extends Iterable<String>> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$headers_u24lambda_u2415 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u2415.headers.clear();
            $this$headers_u24lambda_u2415.putAllHeaders(headers);
            return builder;
        }

        @NotNull
        public final Builder putHeader(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putHeader_u24lambda_u2416 = builder = this;
            boolean bl = false;
            $this$putHeader_u24lambda_u2416.headers.put(name, value);
            return builder;
        }

        @NotNull
        public final Builder putHeaders(@NotNull String name, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$putHeaders_u24lambda_u2417 = builder = this;
            boolean bl = false;
            $this$putHeaders_u24lambda_u2417.headers.put(name, values);
            return builder;
        }

        @NotNull
        public final Builder putAllHeaders(@NotNull Headers headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder $this$putAllHeaders_u24lambda_u2418 = builder = this;
            boolean bl = false;
            $this$putAllHeaders_u24lambda_u2418.headers.putAll(headers);
            return builder;
        }

        @NotNull
        public final Builder putAllHeaders(@NotNull Map<String, ? extends Iterable<String>> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$putAllHeaders_u24lambda_u2419 = builder = this;
            boolean bl = false;
            $this$putAllHeaders_u24lambda_u2419.headers.putAll(headers);
            return builder;
        }

        @NotNull
        public final Builder replaceHeaders(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$replaceHeaders_u24lambda_u2420 = builder = this;
            boolean bl = false;
            $this$replaceHeaders_u24lambda_u2420.headers.replace(name, value);
            return builder;
        }

        @NotNull
        public final Builder replaceHeaders(@NotNull String name, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$replaceHeaders_u24lambda_u2421 = builder = this;
            boolean bl = false;
            $this$replaceHeaders_u24lambda_u2421.headers.replace(name, values);
            return builder;
        }

        @NotNull
        public final Builder replaceAllHeaders(@NotNull Headers headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder $this$replaceAllHeaders_u24lambda_u2422 = builder = this;
            boolean bl = false;
            $this$replaceAllHeaders_u24lambda_u2422.headers.replaceAll(headers);
            return builder;
        }

        @NotNull
        public final Builder replaceAllHeaders(@NotNull Map<String, ? extends Iterable<String>> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$replaceAllHeaders_u24lambda_u2423 = builder = this;
            boolean bl = false;
            $this$replaceAllHeaders_u24lambda_u2423.headers.replaceAll(headers);
            return builder;
        }

        @NotNull
        public final Builder removeHeaders(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$removeHeaders_u24lambda_u2424 = builder = this;
            boolean bl = false;
            $this$removeHeaders_u24lambda_u2424.headers.remove(name);
            return builder;
        }

        @NotNull
        public final Builder removeAllHeaders(@NotNull Set<String> names) {
            Builder builder;
            Intrinsics.checkNotNullParameter(names, (String)"names");
            Builder $this$removeAllHeaders_u24lambda_u2425 = builder = this;
            boolean bl = false;
            $this$removeAllHeaders_u24lambda_u2425.headers.removeAll(names);
            return builder;
        }

        @NotNull
        public final Builder queryParams(@NotNull QueryParams queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)queryParams, (String)"queryParams");
            Builder $this$queryParams_u24lambda_u2426 = builder = this;
            boolean bl = false;
            $this$queryParams_u24lambda_u2426.queryParams.clear();
            $this$queryParams_u24lambda_u2426.putAllQueryParams(queryParams);
            return builder;
        }

        @NotNull
        public final Builder queryParams(@NotNull Map<String, ? extends Iterable<String>> queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Builder $this$queryParams_u24lambda_u2427 = builder = this;
            boolean bl = false;
            $this$queryParams_u24lambda_u2427.queryParams.clear();
            $this$queryParams_u24lambda_u2427.putAllQueryParams(queryParams);
            return builder;
        }

        @NotNull
        public final Builder putQueryParam(@NotNull String key, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putQueryParam_u24lambda_u2428 = builder = this;
            boolean bl = false;
            $this$putQueryParam_u24lambda_u2428.queryParams.put(key, value);
            return builder;
        }

        @NotNull
        public final Builder putQueryParams(@NotNull String key, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$putQueryParams_u24lambda_u2429 = builder = this;
            boolean bl = false;
            $this$putQueryParams_u24lambda_u2429.queryParams.put(key, values);
            return builder;
        }

        @NotNull
        public final Builder putAllQueryParams(@NotNull QueryParams queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)queryParams, (String)"queryParams");
            Builder $this$putAllQueryParams_u24lambda_u2430 = builder = this;
            boolean bl = false;
            $this$putAllQueryParams_u24lambda_u2430.queryParams.putAll(queryParams);
            return builder;
        }

        @NotNull
        public final Builder putAllQueryParams(@NotNull Map<String, ? extends Iterable<String>> queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Builder $this$putAllQueryParams_u24lambda_u2431 = builder = this;
            boolean bl = false;
            $this$putAllQueryParams_u24lambda_u2431.queryParams.putAll(queryParams);
            return builder;
        }

        @NotNull
        public final Builder replaceQueryParams(@NotNull String key, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$replaceQueryParams_u24lambda_u2432 = builder = this;
            boolean bl = false;
            $this$replaceQueryParams_u24lambda_u2432.queryParams.replace(key, value);
            return builder;
        }

        @NotNull
        public final Builder replaceQueryParams(@NotNull String key, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$replaceQueryParams_u24lambda_u2433 = builder = this;
            boolean bl = false;
            $this$replaceQueryParams_u24lambda_u2433.queryParams.replace(key, values);
            return builder;
        }

        @NotNull
        public final Builder replaceAllQueryParams(@NotNull QueryParams queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)queryParams, (String)"queryParams");
            Builder $this$replaceAllQueryParams_u24lambda_u2434 = builder = this;
            boolean bl = false;
            $this$replaceAllQueryParams_u24lambda_u2434.queryParams.replaceAll(queryParams);
            return builder;
        }

        @NotNull
        public final Builder replaceAllQueryParams(@NotNull Map<String, ? extends Iterable<String>> queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Builder $this$replaceAllQueryParams_u24lambda_u2435 = builder = this;
            boolean bl = false;
            $this$replaceAllQueryParams_u24lambda_u2435.queryParams.replaceAll(queryParams);
            return builder;
        }

        @NotNull
        public final Builder removeQueryParams(@NotNull String key) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder $this$removeQueryParams_u24lambda_u2436 = builder = this;
            boolean bl = false;
            $this$removeQueryParams_u24lambda_u2436.queryParams.remove(key);
            return builder;
        }

        @NotNull
        public final Builder removeAllQueryParams(@NotNull Set<String> keys) {
            Builder builder;
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Builder $this$removeAllQueryParams_u24lambda_u2437 = builder = this;
            boolean bl = false;
            $this$removeAllQueryParams_u24lambda_u2437.queryParams.removeAll(keys);
            return builder;
        }

        @NotNull
        public final Timeout timeout() {
            return this.timeout;
        }

        @NotNull
        public final Builder fromEnv() {
            Builder builder;
            block7: {
                String string;
                String string2;
                String string3;
                String it;
                String string4;
                Builder $this$fromEnv_u24lambda_u2442 = builder = this;
                boolean bl = false;
                String string5 = System.getProperty("hiddenlayer.baseUrl");
                if (string5 == null) {
                    string5 = System.getenv("HIDDENLAYER_BASE_URL");
                }
                if ((string4 = string5) != null) {
                    it = string4;
                    boolean bl2 = false;
                    $this$fromEnv_u24lambda_u2442.baseUrl(it);
                }
                if ((string3 = System.getProperty("hiddenlayer.token")) == null) {
                    string3 = System.getenv("HIDDENLAYER_TOKEN");
                }
                String string6 = string4 = string3;
                if (string6 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"System.getProperty(\"hidd\u2026tenv(\"HIDDENLAYER_TOKEN\")");
                    it = string4;
                    boolean bl3 = false;
                    $this$fromEnv_u24lambda_u2442.bearerToken(it);
                }
                if ((string2 = System.getProperty("hiddenlayer.clientId")) == null) {
                    string2 = System.getenv("HIDDENLAYER_CLIENT_ID");
                }
                if ((string4 = string2) != null) {
                    it = string4;
                    boolean bl4 = false;
                    $this$fromEnv_u24lambda_u2442.clientId(it);
                }
                if ((string = System.getProperty("hiddenlayer.clientSecret")) == null) {
                    string = System.getenv("HIDDENLAYER_CLIENT_SECRET");
                }
                if ((string4 = string) == null) break block7;
                it = string4;
                boolean bl5 = false;
                $this$fromEnv_u24lambda_u2442.clientSecret(it);
            }
            return builder;
        }

        @NotNull
        public final ClientOptions build() {
            HttpClient httpClient;
            Sleeper sleeper;
            Executor streamHandlerExecutor2;
            HttpClient httpClient2 = Check.checkRequired("httpClient", this.httpClient);
            Executor executor = this.streamHandlerExecutor;
            if (executor == null) {
                ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){
                    @NotNull
                    private final ThreadFactory threadFactory;
                    @NotNull
                    private final AtomicLong count;
                    {
                        ThreadFactory threadFactory = Executors.defaultThreadFactory();
                        Intrinsics.checkNotNullExpressionValue((Object)threadFactory, (String)"defaultThreadFactory()");
                        this.threadFactory = threadFactory;
                        this.count = new AtomicLong(0L);
                    }

                    @NotNull
                    public Thread newThread(@NotNull Runnable runnable) {
                        Thread thread;
                        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
                        Thread it = thread = this.threadFactory.newThread(runnable);
                        boolean bl = false;
                        it.setName("hiddenlayer-stream-handler-thread-" + this.count.getAndIncrement());
                        Thread thread2 = thread;
                        Intrinsics.checkNotNullExpressionValue((Object)thread2, (String)"threadFactory.newThread(\u2026                        }");
                        return thread2;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newCachedThreadPool(\n   \u2026                        )");
                executor = streamHandlerExecutor2 = (Executor)new PhantomReachableExecutorService(executorService);
            }
            if ((sleeper = this.sleeper) == null) {
                sleeper = new PhantomReachableSleeper(new DefaultSleeper());
            }
            Sleeper sleeper2 = sleeper;
            Headers.Builder headers = Headers.Companion.builder();
            QueryParams.Builder queryParams = QueryParams.Companion.builder();
            headers.put("X-Stainless-Lang", "java");
            headers.put("X-Stainless-Arch", Properties.getOsArch());
            headers.put("X-Stainless-OS", Properties.getOsName());
            headers.put("X-Stainless-OS-Version", Properties.getOsVersion());
            headers.put("X-Stainless-Package-Version", Properties.getPackageVersion());
            headers.put("X-Stainless-Runtime", "JRE");
            headers.put("X-Stainless-Runtime-Version", Properties.getJavaVersion());
            String string = this.bearerToken;
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (!(((CharSequence)it).length() == 0)) {
                    headers.put("Authorization", "Bearer " + it);
                }
            }
            headers.replaceAll(this.headers.build());
            queryParams.replaceAll(this.queryParams.build());
            RetryingHttpClient.Builder builder = RetryingHttpClient.Companion.builder();
            if (this.clientId != null && this.clientSecret != null) {
                OAuth2HttpClient.Builder builder2 = OAuth2HttpClient.Companion.builder().httpClient(httpClient2);
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = this.baseUrl;
                if (string2 == null) {
                    string2 = ClientOptions.PROD_US_URL;
                }
                OAuth2HttpClient.Builder builder3 = builder2.tokenUrl(stringBuilder.append(string2).append("/oauth2/token").toString());
                String string3 = this.clientId;
                Intrinsics.checkNotNull((Object)string3);
                OAuth2HttpClient.Builder builder4 = builder3.clientId(string3);
                String string4 = this.clientSecret;
                Intrinsics.checkNotNull((Object)string4);
                httpClient = builder4.clientSecret(string4).jsonMapper(this.jsonMapper).clock(this.clock).build();
            } else {
                httpClient = httpClient2;
            }
            return new ClientOptions(httpClient2, builder.httpClient(httpClient).sleeper(sleeper2).clock(this.clock).maxRetries(this.maxRetries).build(), this.checkJacksonVersionCompatibility, this.jsonMapper, streamHandlerExecutor2, sleeper2, this.clock, this.baseUrl, headers.build(), queryParams.build(), this.responseValidation, this.timeout, this.maxRetries, this.bearerToken, this.clientId, this.clientSecret, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/hiddenlayer/api/core/ClientOptions$Companion;", "", "()V", "PROD_EU_URL", "", "PROD_US_URL", "builder", "Lcom/hiddenlayer/api/core/ClientOptions$Builder;", "fromEnv", "Lcom/hiddenlayer/api/core/ClientOptions;", "hiddenlayer-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        @JvmStatic
        @NotNull
        public final ClientOptions fromEnv() {
            return this.builder().fromEnv().build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

