/*
 * Decompiled with CFR 0.152.
 */
package com.hiddenlayer.api.core;

import com.hiddenlayer.api.core.PhantomReachable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00100\u000f\"\u0004\b\u0000\u0010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00140\u0013H\u0016J@\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00100\u000f\"\u0004\b\u0000\u0010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00140\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J)\u0010\u0015\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00140\u0013H\u0016\u00a2\u0006\u0002\u0010\u0016J9\u0010\u0015\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00140\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016J\u0014\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u001d\u001a\u00020\rH\u0016J)\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u0002H\u0011H\u0016\u00a2\u0006\u0002\u0010\u001fJ\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\u0004\b\u0000\u0010\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/hiddenlayer/api/core/PhantomReachableExecutorService;", "Ljava/util/concurrent/ExecutorService;", "executorService", "(Ljava/util/concurrent/ExecutorService;)V", "awaitTermination", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "execute", "", "command", "Ljava/lang/Runnable;", "invokeAll", "", "Ljava/util/concurrent/Future;", "T", "tasks", "", "Ljava/util/concurrent/Callable;", "invokeAny", "(Ljava/util/Collection;)Ljava/lang/Object;", "(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "isShutdown", "isTerminated", "shutdown", "shutdownNow", "submit", "task", "result", "(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;", "hiddenlayer-java-core"})
public final class PhantomReachableExecutorService
implements ExecutorService {
    @NotNull
    private final ExecutorService executorService;

    public PhantomReachableExecutorService(@NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.executorService = executorService;
        PhantomReachable.closeWhenPhantomReachable((Object)this, (Function0)new Function0<Unit>(){

            public final void invoke() {
                executorService.shutdown();
            }
        });
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.executorService.execute(command);
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> list2 = this.executorService.shutdownNow();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"executorService.shutdownNow()");
        return list2;
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.executorService.awaitTermination(timeout, unit);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        Future<T> future = this.executorService.submit(task);
        Intrinsics.checkNotNullExpressionValue(future, (String)"executorService.submit(task)");
        return future;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, T result) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Future<T> future = this.executorService.submit(task, result);
        Intrinsics.checkNotNullExpressionValue(future, (String)"executorService.submit(task, result)");
        return future;
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Future<?> future = this.executorService.submit(task);
        Intrinsics.checkNotNullExpressionValue(future, (String)"executorService.submit(task)");
        return future;
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) {
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        List list2 = this.executorService.invokeAll(tasks);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"executorService.invokeAll(tasks)");
        return list2;
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        List list2 = this.executorService.invokeAll(tasks, timeout, unit);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"executorService.invokeAll(tasks, timeout, unit)");
        return list2;
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) {
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        return this.executorService.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.executorService.invokeAny(tasks, timeout, unit);
    }
}

