/*
 * Decompiled with CFR 0.152.
 */
package com.hiddenlayer.api.lib;

import com.hiddenlayer.api.client.HiddenLayerClient;
import com.hiddenlayer.api.client.HiddenLayerClientAsync;
import com.hiddenlayer.api.errors.NotFoundException;
import com.hiddenlayer.api.lib.ScanUtilsKt;
import com.hiddenlayer.api.models.scans.jobs.JobRetrieveParams;
import com.hiddenlayer.api.models.scans.results.ScanReport;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r\u001a>\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002\u001a6\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0016\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r\u001a6\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getScanResults", "Lcom/hiddenlayer/api/models/scans/results/ScanReport;", "client", "Lcom/hiddenlayer/api/client/HiddenLayerClient;", "scanId", "", "getScanResultsAsync", "Ljava/util/concurrent/CompletableFuture;", "Lcom/hiddenlayer/api/client/HiddenLayerClientAsync;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "getScanResultsAsyncInternal", "retries", "", "maxRetries", "baseDelay", "", "scheduleNextRetry", "waitForScanResults", "waitForScanResultsAsync", "waitForScanResultsAsyncInternal", "hiddenlayer-java-core"})
public final class ScanUtilsKt {
    private static final Logger logger = Logger.getLogger("ScanUtils");

    @NotNull
    public static final ScanReport getScanResults(@NotNull HiddenLayerClient client, @NotNull String scanId) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)scanId, (String)"scanId");
        int retries = 0;
        int maxRetries = 5;
        long baseDelay = 500L;
        while (retries < maxRetries) {
            try {
                return client.scans().jobs().retrieve(JobRetrieveParams.Companion.builder().scanId(scanId).build());
            }
            catch (NotFoundException e) {
                if (++retries >= maxRetries) {
                    logger.severe("Scan " + scanId + " not found after " + maxRetries + " attempts");
                    throw e;
                }
                long jitter = ThreadLocalRandom.current().nextLong(0L, 500L);
                long delay = baseDelay * (long)retries + jitter;
                logger.info("Scan not yet available, retrying in " + (double)delay / 1000.0 + "s (attempt " + (retries + 1) + '/' + maxRetries + ')');
                Thread.sleep(delay);
            }
        }
        throw new RuntimeException("Scan " + scanId + " not found after " + maxRetries + " attempts");
    }

    @NotNull
    public static final ScanReport waitForScanResults(@NotNull HiddenLayerClient client, @NotNull String scanId) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)scanId, (String)"scanId");
        long baseDelay = 100L;
        int retries = 0;
        ScanReport scanResults = null;
        while (true) {
            try {
                scanResults = client.scans().jobs().retrieve(JobRetrieveParams.Companion.builder().scanId(scanId).build());
                ScanReport.Status status = scanResults.status();
                if (Intrinsics.areEqual((Object)status, (Object)ScanReport.Status.DONE) || Intrinsics.areEqual((Object)status, (Object)ScanReport.Status.FAILED) || Intrinsics.areEqual((Object)status, (Object)ScanReport.Status.CANCELED)) break;
                logger.info("scan status: " + status);
            }
            catch (NotFoundException e) {
                logger.info("scan not found yet, retrying...");
            }
            long jitter = ThreadLocalRandom.current().nextLong(0L, 1000L);
            long delay = baseDelay * (long)Math.pow(2.0, ++retries) + jitter;
            delay = Math.min(delay, 30000L);
            Thread.sleep(delay);
        }
        ScanReport scanReport = scanResults;
        Intrinsics.checkNotNull((Object)scanReport);
        return scanReport;
    }

    @NotNull
    public static final CompletableFuture<ScanReport> getScanResultsAsync(@NotNull HiddenLayerClientAsync client, @NotNull String scanId, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)scanId, (String)"scanId");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return ScanUtilsKt.getScanResultsAsyncInternal(client, scanId, 0, 5, 500L, executor);
    }

    private static final CompletableFuture<ScanReport> getScanResultsAsyncInternal(HiddenLayerClientAsync client, String scanId, int retries, int maxRetries, long baseDelay, ScheduledExecutorService executor) {
        CompletionStage completionStage = ((CompletableFuture)client.scans().jobs().retrieve(JobRetrieveParams.Companion.builder().scanId(scanId).build()).handle((arg_0, arg_1) -> ScanUtilsKt.getScanResultsAsyncInternal$lambda$0((Function2)new Function2<ScanReport, Throwable, CompletableFuture<ScanReport>>(retries, maxRetries, scanId, baseDelay, executor, client){
            final /* synthetic */ int $retries;
            final /* synthetic */ int $maxRetries;
            final /* synthetic */ String $scanId;
            final /* synthetic */ long $baseDelay;
            final /* synthetic */ ScheduledExecutorService $executor;
            final /* synthetic */ HiddenLayerClientAsync $client;
            {
                this.$retries = $retries;
                this.$maxRetries = $maxRetries;
                this.$scanId = $scanId;
                this.$baseDelay = $baseDelay;
                this.$executor = $executor;
                this.$client = $client;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final CompletableFuture<ScanReport> invoke(ScanReport result, Throwable exception) {
                CompletableFuture<ScanReport> completableFuture;
                ScanReport scanReport = result;
                if (scanReport != null) {
                    completableFuture = CompletableFuture.completedFuture(scanReport);
                } else if (exception instanceof NotFoundException) {
                    if (this.$retries >= this.$maxRetries) {
                        ScanUtilsKt.access$getLogger$p().severe("Scan " + this.$scanId + " not found after " + this.$maxRetries + " attempts");
                        CompletableFuture<T> failedFuture = new CompletableFuture<T>();
                        failedFuture.completeExceptionally(exception);
                        completableFuture = failedFuture;
                    } else {
                        long jitter = ThreadLocalRandom.current().nextLong(0L, 500L);
                        long delay = this.$baseDelay * (long)(this.$retries + 1) + jitter;
                        ScanUtilsKt.access$getLogger$p().info("Scan not yet available, retrying in " + (double)delay / 1000.0 + "s (attempt " + (this.$retries + 2) + '/' + this.$maxRetries + ')');
                        CompletableFuture<T> future = new CompletableFuture<T>();
                        this.$executor.schedule(() -> getScanResultsAsyncInternal.1.invoke$lambda$1(this.$client, this.$scanId, this.$retries, this.$maxRetries, this.$baseDelay, this.$executor, future), delay, TimeUnit.MILLISECONDS);
                        completableFuture = future;
                    }
                } else {
                    void var3_5;
                    CompletableFuture<T> failedFuture = new CompletableFuture<T>();
                    Throwable throwable = exception;
                    if (throwable == null) {
                        throwable = new RuntimeException("Unknown error");
                    }
                    failedFuture.completeExceptionally(throwable);
                    completableFuture = var3_5;
                }
                return completableFuture;
            }

            private static final void invoke$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0, p1);
            }

            private static final void invoke$lambda$1(HiddenLayerClientAsync $client, String $scanId, int $retries, int $maxRetries, long $baseDelay, ScheduledExecutorService $executor, CompletableFuture $future) {
                Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
                Intrinsics.checkNotNullParameter((Object)$scanId, (String)"$scanId");
                Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
                Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
                ScanUtilsKt.access$getScanResultsAsyncInternal($client, $scanId, $retries + 1, $maxRetries, $baseDelay, $executor).whenComplete((arg_0, arg_1) -> getScanResultsAsyncInternal.1.invoke$lambda$1$lambda$0((Function2)new Function2<ScanReport, Throwable, Unit>((CompletableFuture<ScanReport>)$future){
                    final /* synthetic */ CompletableFuture<ScanReport> $future;
                    {
                        this.$future = $future;
                        super(2);
                    }

                    public final void invoke(ScanReport result, Throwable ex) {
                        if (ex != null) {
                            this.$future.completeExceptionally(ex);
                        } else {
                            this.$future.complete(result);
                        }
                    }
                }, arg_0, arg_1));
            }
        }, arg_0, arg_1))).thenCompose(arg_0 -> ScanUtilsKt.getScanResultsAsyncInternal$lambda$1(getScanResultsAsyncInternal.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"client: HiddenLayerClien\u2026      .thenCompose { it }");
        return completionStage;
    }

    @NotNull
    public static final CompletableFuture<ScanReport> waitForScanResultsAsync(@NotNull HiddenLayerClientAsync client, @NotNull String scanId, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)scanId, (String)"scanId");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return ScanUtilsKt.waitForScanResultsAsyncInternal(client, scanId, 0, 100L, executor);
    }

    private static final CompletableFuture<ScanReport> waitForScanResultsAsyncInternal(HiddenLayerClientAsync client, String scanId, int retries, long baseDelay, ScheduledExecutorService executor) {
        CompletionStage completionStage = ((CompletableFuture)client.scans().jobs().retrieve(JobRetrieveParams.Companion.builder().scanId(scanId).build()).handle((arg_0, arg_1) -> ScanUtilsKt.waitForScanResultsAsyncInternal$lambda$2((Function2)new Function2<ScanReport, Throwable, CompletableFuture<ScanReport>>(client, scanId, retries, baseDelay, executor){
            final /* synthetic */ HiddenLayerClientAsync $client;
            final /* synthetic */ String $scanId;
            final /* synthetic */ int $retries;
            final /* synthetic */ long $baseDelay;
            final /* synthetic */ ScheduledExecutorService $executor;
            {
                this.$client = $client;
                this.$scanId = $scanId;
                this.$retries = $retries;
                this.$baseDelay = $baseDelay;
                this.$executor = $executor;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final CompletableFuture<ScanReport> invoke(ScanReport result, Throwable exception) {
                CompletableFuture completableFuture;
                if (result != null) {
                    ScanReport.Status status = result.status();
                    if (Intrinsics.areEqual((Object)status, (Object)ScanReport.Status.DONE) || Intrinsics.areEqual((Object)status, (Object)ScanReport.Status.FAILED) || Intrinsics.areEqual((Object)status, (Object)ScanReport.Status.CANCELED)) {
                        completableFuture = CompletableFuture.completedFuture(result);
                    } else {
                        ScanUtilsKt.access$getLogger$p().info("scan status: " + status);
                        completableFuture = ScanUtilsKt.access$scheduleNextRetry(this.$client, this.$scanId, this.$retries + 1, this.$baseDelay, this.$executor);
                    }
                } else if (exception instanceof NotFoundException) {
                    ScanUtilsKt.access$getLogger$p().info("scan not found yet, retrying...");
                    completableFuture = ScanUtilsKt.access$scheduleNextRetry(this.$client, this.$scanId, this.$retries + 1, this.$baseDelay, this.$executor);
                } else {
                    void var3_4;
                    CompletableFuture<T> failedFuture = new CompletableFuture<T>();
                    Throwable throwable = exception;
                    if (throwable == null) {
                        throwable = new RuntimeException("Unknown error");
                    }
                    failedFuture.completeExceptionally(throwable);
                    completableFuture = var3_4;
                }
                return completableFuture;
            }
        }, arg_0, arg_1))).thenCompose(arg_0 -> ScanUtilsKt.waitForScanResultsAsyncInternal$lambda$3(waitForScanResultsAsyncInternal.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"client: HiddenLayerClien\u2026      .thenCompose { it }");
        return completionStage;
    }

    private static final CompletableFuture<ScanReport> scheduleNextRetry(HiddenLayerClientAsync client, String scanId, int retries, long baseDelay, ScheduledExecutorService executor) {
        long jitter = ThreadLocalRandom.current().nextLong(0L, 1000L);
        long delay = baseDelay * (long)Math.pow(2.0, retries) + jitter;
        delay = Math.min(delay, 30000L);
        CompletableFuture<ScanReport> future = new CompletableFuture<ScanReport>();
        executor.schedule(() -> ScanUtilsKt.scheduleNextRetry$lambda$5(client, scanId, retries, baseDelay, executor, future), delay, TimeUnit.MILLISECONDS);
        return future;
    }

    private static final CompletableFuture getScanResultsAsyncInternal$lambda$0(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletableFuture)$tmp0.invoke(p0, (Object)p1);
    }

    private static final CompletionStage getScanResultsAsyncInternal$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final CompletableFuture waitForScanResultsAsyncInternal$lambda$2(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletableFuture)$tmp0.invoke(p0, (Object)p1);
    }

    private static final CompletionStage waitForScanResultsAsyncInternal$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final void scheduleNextRetry$lambda$5$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void scheduleNextRetry$lambda$5(HiddenLayerClientAsync $client, String $scanId, int $retries, long $baseDelay, ScheduledExecutorService $executor, CompletableFuture $future) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$scanId, (String)"$scanId");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        ScanUtilsKt.waitForScanResultsAsyncInternal($client, $scanId, $retries, $baseDelay, $executor).whenComplete((arg_0, arg_1) -> ScanUtilsKt.scheduleNextRetry$lambda$5$lambda$4((Function2)new Function2<ScanReport, Throwable, Unit>((CompletableFuture<ScanReport>)$future){
            final /* synthetic */ CompletableFuture<ScanReport> $future;
            {
                this.$future = $future;
                super(2);
            }

            public final void invoke(ScanReport result, Throwable ex) {
                if (ex != null) {
                    this.$future.completeExceptionally(ex);
                } else {
                    this.$future.complete(result);
                }
            }
        }, arg_0, arg_1));
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ CompletableFuture access$getScanResultsAsyncInternal(HiddenLayerClientAsync client, String scanId, int retries, int maxRetries, long baseDelay, ScheduledExecutorService executor) {
        return ScanUtilsKt.getScanResultsAsyncInternal(client, scanId, retries, maxRetries, baseDelay, executor);
    }

    public static final /* synthetic */ CompletableFuture access$scheduleNextRetry(HiddenLayerClientAsync client, String scanId, int retries, long baseDelay, ScheduledExecutorService executor) {
        return ScanUtilsKt.scheduleNextRetry(client, scanId, retries, baseDelay, executor);
    }
}

