/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client;

import com.ibm.optim.oaas.client.impl.ClientMessageCodes;

/**
 * Security exception thrown when the client ID is not known or invalid.
 */
public class InvalidClientIdException extends SecurityException {
  private static final long serialVersionUID = -1;

  public InvalidClientIdException(Object[] params, OperationException e) {
    super(ClientMessageCodes.AKCJC5047E_INVALID_CLIENT_ID_EXCEPTION.name(), e, params);
  }

  public InvalidClientIdException(String clientId) {
    super(ClientMessageCodes.AKCJC5047E_INVALID_CLIENT_ID_EXCEPTION.name(), clientId);
  }
}