/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;

/**
 * A simple log formatter that prints a log message on one line and that can be
 * configured in your application.
 *
 */
public class OaasLogFormatter extends Formatter {
  private final DateFormat dateFormat;

  public OaasLogFormatter() {
    dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    dateFormat.setTimeZone(TimeZone.GMT_ZONE);
  }

  @Override
  public String format(LogRecord record) {
    StringBuffer sb = new StringBuffer();
    sb.append(dateFormat.format(new Date(record.getMillis())));

    sb.append(" ");
    sb.append(record.getLevel().getName().charAt(0));
    sb.append(" ");
    sb.append(formatMessage(record));

    Throwable ex = record.getThrown();
    if (ex != null) {
      sb.append("\r\n");
      sb.append("Exception: ");
      StringWriter stringWriter = new StringWriter();
      ex.printStackTrace(new PrintWriter(stringWriter));
      sb.append(stringWriter.toString());

      Throwable rootCause = OaasException.getRootCause(ex);
      if ((rootCause != null) && (rootCause != ex)) {
        sb.append("\r\n");
        sb.append("Root cause: ");
        stringWriter = new StringWriter();
        rootCause.printStackTrace(new PrintWriter(stringWriter));
        sb.append(stringWriter.toString());
      }
    }
    sb.append("\r\n");

    return sb.toString();
  }
}