/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client;

import org.apache.http.HttpStatus;

import com.ibm.optim.oaas.client.impl.ClientMessageCodes;

/**
 * Exception occurred when parsing a message body or parameter.
 *
 */
public class ParsingException extends OaasRuntimeException {
  private static final long serialVersionUID = 1L;
  private static final String BUNDLE_NAME = ClientMessageCodes.class.getName();

  public ParsingException(Exception e, String message) {
    super(ClientMessageCodes.AKCJC5004E_PARSING_EXCEPTION.name(), e, message);
  }

  @Override
  protected String getResourceBundleName() {
    return BUNDLE_NAME;
  }

  public int getRestStatusCode() {
    return HttpStatus.SC_BAD_REQUEST;
  }
}