/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client;

import org.apache.http.HttpStatus;

import com.ibm.optim.oaas.client.impl.ClientMessageCodes;

/** 
 * Exception to report invalid or forbidden operations 
 */
public class SecurityException extends OaasRuntimeException {
  private static final long serialVersionUID = -1;

  private static final String BUNDLE_NAME = ClientMessageCodes.class.getName();

  /**
   * Create an exception.
   * 
   * @param message
   *            The exception message.
   * @param cause
   *            The cause of the exception.
   * @param parameters
   *            The optional parameters for the message.
   */
  public SecurityException(String message, Throwable cause,
                           Object... parameters) {
    super(message, cause, parameters);
  }

  /**
   * Create an exception.
   * 
   * @param message
   *            The exception message.
   * @param parameters
   *            The optional parameters for the message.
   */
  public SecurityException(String message, Object... parameters) {
    super(message, parameters);
  }

  public SecurityException(int code, String message) {
    super(ClientMessageCodes.AKCJC5044E_AUTHSERVER.name(),code, message);
  }

  public SecurityException(String code) {
    super(code);
  }

  public SecurityException(Throwable e) {
    super(ClientMessageCodes.AKCJC5043E_ERROR.name(), e.getLocalizedMessage());
  }

  @Override
  public int getRestStatusCode(){
    return HttpStatus.SC_FORBIDDEN;
  }

  @Override
  protected String getResourceBundleName() {
    return BUNDLE_NAME;
  }
}