/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Remote exception data returned by the server. When an exception is raised by
 * the remote server, additional information might be returned.
 */
@ApiModel(value = "ServerExceptionData", description = "Additional information associated with a remote exception")
public interface ServerExceptionData {
  /**
   * Returns the server-side exception code.
   * 
   * @return The server-side exception code.
   */
  @ApiModelProperty(value = "Server side exception code", required = true)
  public abstract String getCode();

  /**
   * Returns the server-side exception message.
   * 
   * @return The formatted server-side exception message.
   */
  @ApiModelProperty(value = "Formatted exception message")
  public abstract String getMessage();

  /**
   * Returns the server-side localized exception message.
   * 
   * @return The localized formatted server-side exception message.
   */
  @ApiModelProperty(value = "Formatted localized exception message")
  public abstract String getLocalizedMessage();

  /**
   * Returns the server-side exception class name.
   * 
   * @return The server-side exception class name.
   */
  @ApiModelProperty(value = "The exception class")
  public abstract String getExceptionclass();

  /**
   * Returns the list of parameters associated with the exception.
   * 
   * @return A list of parameter strings.
   */
  @ApiModelProperty(value = "List of exception parameters")
  public abstract List<String> getParameters();
}