/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.impl;

//@IloMessageCodeConfiguration(prefix = "AKCJC", rangeMin = 5000, rangeMax = 5099)
public class ClientMessageCodes extends OaasMessageCode {
  public static OaasMessageCode AKCJC5001E_OPERATION_EXCEPTION;
  public static OaasMessageCode AKCJC5002E_INTERNAL_EXCEPTION;
  public static OaasMessageCode AKCJC5003I_RETRY_OPERATION_EXCEPTION;
  public static OaasMessageCode AKCJC5004E_PARSING_EXCEPTION;
  public static OaasMessageCode AKCJC5005E_INVALID_PARAMETER_EXCEPTION;
  public static OaasMessageCode AKCJC5006I_RETRY_OPERATION_CAUSE_EXCEPTION;

  public static OaasMessageCode AKCJC5010E_OPERATION_GATEWAY_EXCEPTION;
  public static OaasMessageCode AKCJC5011E_OPERATION_NETWORK_EXCEPTION;

  public static OaasMessageCode AKCJC5040E_NOT_ALLOWED_EXCEPTION;
  public static OaasMessageCode AKCJC5041E_TOKEN_NOT_PROVIDED;
  public static OaasMessageCode AKCJC5042E_INVALID_BASIC_AUTH;
  public static OaasMessageCode AKCJC5043E_ERROR;
  public static OaasMessageCode AKCJC5044E_AUTHSERVER;
  public static OaasMessageCode AKCJC5045E_AUTHSERVER_NOTFOUND;
  public static OaasMessageCode AKCJC5046E_AUTHSERVER_INVALID;
  public static OaasMessageCode AKCJC5047E_INVALID_CLIENT_ID_EXCEPTION;

  public static OaasMessageCode AKCJC5050E_GATEWAY_CERTIFICATE_MISSING;
  public static OaasMessageCode AKCJC5051E_GATEWAY_CERTIFICATE_NOT_ALLOWED;
  public static OaasMessageCode AKCJC5052E_GATEWAY_DOMAIN_NOT_ALLOWED;

  public static OaasMessageCode AKCJC5060E_BLUEMIX_CREDENTIALS_MISSING;

  static {
    initializeCodes(ClientMessageCodes.class, ClientMessageCodes.class.getPackage().getName());
  }
}