/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.impl;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Information returned when a specific element is deleted using the REST API.
 */
@ApiModel(value = "DeletionResponse", description = "Information returned when a specific element is deleted")
public interface DeletionResponse {
  /**
   * Returns the status of an element deletion.
   * @return The status.
   */
  @ApiModelProperty(value = "The deletion status", required = true)
  public abstract DeletionStatus getStatus();
}