/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ibm.optim.oaas.client.ServerExceptionData;

@JsonAutoDetect(fieldVisibility = Visibility.ANY, getterVisibility = Visibility.NONE, setterVisibility = Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ServerExceptionDataImpl implements ServerExceptionData {
  public static String HTTP_X_EXCEPTION = "X-Exception";

  private String exclass;
  private String code;
  private String message;
  private List<String> parameters = new ArrayList<String>();
  private String localizedMessage;
  private String stacktrace;

  public ServerExceptionDataImpl() {
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.impl.ServerExceptionData#getCode()
   */
  @Override
  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.impl.ServerExceptionData#getMessage()
   */
  @Override
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  /*
   * (non-Javadoc)
   * 
   * @see
   * com.ibm.optim.oaas.client.impl.ServerExceptionData#getLocalizedMessage()
   */
  @Override
  public String getLocalizedMessage() {
    return localizedMessage;
  }

  public void setLocalizedMessage(String localizedMessage) {
    this.localizedMessage = localizedMessage;
  }

  public String getStacktrace() {
    return stacktrace;
  }

  public void setStacktrace(Throwable th) {
    Writer result = new StringWriter();
    PrintWriter printWriter = new PrintWriter(result);
    th.printStackTrace(printWriter);
    stacktrace = result.toString();
  }

  /*
   * (non-Javadoc)
   * 
   * @see
   * com.ibm.optim.oaas.client.impl.ServerExceptionData#getExceptionclass()
   */
  @Override
  public String getExceptionclass() {
    return exclass;
  }

  public void setExceptionclass(String exclass) {
    this.exclass = exclass;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.impl.ServerExceptionData#getParameters()
   */
  @Override
  public List<String> getParameters() {
    return parameters;
  }

  public void setParameters(Object[] parameters) {
    if (parameters != null) {
      for (int i = 0; i < parameters.length; i++) {
        this.parameters.add(parameters[i].toString());
      }
    }
  }

  public String toString() {
    StringBuffer buffer = new StringBuffer();
    buffer.append("[");
    if (exclass != null) {
      buffer.append(" class=" + exclass);
    }
    if (code != null) {
      buffer.append(" code=" + code);
    }
    if (message != null) {
      buffer.append(" message=" + message);
    }
    if (!parameters.isEmpty()) {
      buffer.append(" parameters=" + parameters);
    }
    if (stacktrace != null) {
      buffer.append(" stacktrace=" + stacktrace);
    }
    buffer.append("]");
    return buffer.toString();
  }
}