/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job;

import java.io.IOException;
import java.io.OutputStream;

/**
 * Interface of a custom attachment writer.
 *
 */
public interface AttachmentContentWriter {
  /**
   * Writes the content of an attachment directly to the HTTP stream.
   * 
   * @param outstream the HTTP stream.
   * @throws IOException if the stream can not be written to for any reason.
   */
  public void writeTo(OutputStream outstream) throws IOException;

  /**
   * Indicates if the content can be resent in a retry.
   * @return {@code true} if repeatable, {@code false} otherwise.
   */
  public boolean isRepeatable();
}