/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job;

import com.ibm.optim.oaas.client.OperationException;
import com.ibm.optim.oaas.client.job.impl.JobMessageCodes;
import com.ibm.optim.oaas.client.job.model.impl.JobSubscriptionImpl;

/**
 * Exception that is thrown when a given attachment size has exceeded the limit defined in the
 * subscription.
 */
public class AttachmentStorageLimitException extends SubscriptionException {
  private static final long serialVersionUID = -1;

  public AttachmentStorageLimitException(Object[] params, OperationException e) {
    super(JobMessageCodes.AKCJC5112E_ATTACHMENT_STORAGE_LIMIT_EXCEPTION.name(), e, params);
  }

  public AttachmentStorageLimitException(String id,
                                         JobSubscriptionImpl subscription,
                                         long maxAttachmentSize,
                                         String name) {
    super(JobMessageCodes.AKCJC5112E_ATTACHMENT_STORAGE_LIMIT_EXCEPTION
          .name(), id, subscription.toString(), maxAttachmentSize, name);
  }
}
