/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job;

import com.ibm.optim.oaas.client.OperationException;
import com.ibm.optim.oaas.client.job.impl.JobMessageCodes;
import com.ibm.optim.oaas.client.job.model.JobExecutionStatus;

/**
 * Validation exception thrown when an action is attempted on a job which does not have the right status
 * to handle this action.
 */
public class IllegalJobStatusException extends ValidationException {
  private static final long serialVersionUID = 2498346952092443023L;

  public IllegalJobStatusException(Object[] params, OperationException e) {
    super(JobMessageCodes.AKCJC5126E_JOB_STATUS_EXCEPTION.name(), e, params);
  }

  /**
   * Construct a job status exception for jobs with the given ID and status.
   * 
   * @param jobID The job id.
   * @param jobStatus The job status.
   */
  public IllegalJobStatusException(String jobID, JobExecutionStatus jobStatus) {
    super(JobMessageCodes.AKCJC5126E_JOB_STATUS_EXCEPTION.name(), jobID, jobStatus);
  }

  /**
   * Construct a job status exception for jobs with the given ID and status.
   * 
   * @param jobID The job id.
   * @param jobStatus The job status.
   */
  public IllegalJobStatusException(String jobID, String jobStatus) {
    super(JobMessageCodes.AKCJC5126E_JOB_STATUS_EXCEPTION.name(), jobID, jobStatus);
  }
}