/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job;

import org.apache.http.impl.client.CloseableHttpClient;

/**
 * Builder interface to configure a job client.
 *
 */
public interface JobClientBuilder {
  /**
   * Sets the HTTP client.
   * 
   * @param httpClient
   *            The HTTP client.
   * @return The builder.
   */
  public JobClientBuilder http(CloseableHttpClient httpClient);

  /**
   * Returns the configured job client.
   * 
   * @return The configured job client.
   */
  public JobClient build();
}