/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job;

import com.ibm.optim.oaas.client.OaasException;
import com.ibm.optim.oaas.client.job.impl.JobMessageCodes;

/**
 * Exception associated with a job.
 */
public abstract class JobException extends OaasException {
  private static final long serialVersionUID = 1L;

  private static final String BUNDLE_NAME = JobMessageCodes.class.getName();

  /**
   * Create a new job exception.
   * 
   * @param message
   *            The exception message.
   * @param cause
   *            The cause of the exception.
   * @param parameters
   *            The optional parameters for the message.
   */
  protected JobException(String message, Throwable cause,
                         Object... parameters) {
    super(message, cause, parameters);
  }

  /**
   * Create a new job exception.
   * 
   * @param message
   *            The exception message.
   * @param parameters
   *            The optional parameters for the message.
   */
  protected JobException(String message, Object... parameters) {
    super(message, parameters);
  }

  @Override
  protected String getResourceBundleName() {
    return BUNDLE_NAME;
  }
}