/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job;

import com.ibm.optim.oaas.client.OperationException;
import com.ibm.optim.oaas.client.job.impl.JobMessageCodes;
import com.ibm.optim.oaas.client.job.model.impl.JobSubscriptionImpl;

/**
 * Subscription exception thrown when the maximum number of jobs has been reached.
 */
public class JobLimitException extends SubscriptionException {
  private static final long serialVersionUID = -1;

  public JobLimitException(Object[] params, OperationException e) {
    super(JobMessageCodes.AKCJC5111E_JOB_LIMIT_EXCEPTION.name(), e, params);
  }

  public JobLimitException(String id, JobSubscriptionImpl subscription, int maxNumberOfJobs) {
    super(JobMessageCodes.AKCJC5111E_JOB_LIMIT_EXCEPTION.name(), id,
          subscription.toString(), maxNumberOfJobs);
  }
}