/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job;

import org.apache.http.HttpStatus;

import com.ibm.optim.oaas.client.OperationException;
import com.ibm.optim.oaas.client.job.impl.JobMessageCodes;

/**
 * Job exception thrown when the job cannot be found.
 *
 */
public class JobNotFoundException extends JobException {
  private static final long serialVersionUID = 1L;

  private String jobid;

  public JobNotFoundException(String jobid, OperationException e) {
    super(JobMessageCodes.AKCJC5101E_JOB_NOT_FOUND_EXCEPTION.name(), e, jobid);
    this.jobid = jobid;
  }

  public JobNotFoundException(String jobid) {
    super(JobMessageCodes.AKCJC5101E_JOB_NOT_FOUND_EXCEPTION.name(), jobid);
    this.jobid = jobid;
  }

  /**
   * Returns the ID of the associated job.
   * 
   * @return The job ID.
   */
  public String getJobId() {
    return jobid;
  }

  @Override
  public int getRestStatusCode() {
    return HttpStatus.SC_NOT_FOUND;
  }
}