/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job;

import java.util.List;

import com.ibm.optim.oaas.client.job.model.Job;
import com.ibm.optim.oaas.client.job.model.JobCreationData;

/**
 * Interface of a job response to get the job status and result values.
 */
public interface JobResponse {
  /**
   * Returns the job client.
   * 
   * @return The job client.
   */
  public JobClient getClient();

  /**
   * Returns The job data used to create and initialize the job.
   * 
   * @return The job creation data.
   */
  public JobCreationData getData();

  /**
   * Returns The job ID.
   * 
   * @return The job ID or <code>null</code> if the ID has not yet been
   *         assigned by the server.
   */
  String getJobId();

  /**
   * Returns the job description as it was stored when it completed.
   * If the latest job description must be fetched, then the job client must be used. 
   * @see JobClient#getJob(String)
   * 
   * @return The job.
   */
  Job getJob();

  /**
   * Returns The list of job result output values.
   * 
   * @return The list of job output.
   */
  List<? extends JobOutput> getOutput();

  /**
   * Returns The list of job log output values.
   * 
   * @return The list of job log output.
   */
  List<? extends JobLogOutput> getLogOutput();
}