/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job;

import org.apache.http.HttpStatus;

/**
 * Base exception of all issues related to subscription settings and limits.
 */
public abstract class SubscriptionException extends JobException {
  private static final long serialVersionUID = 2498346952092443023L;

  /**
   * Create an exception.
   * 
   * @param message
   *            The exception message.
   * @param cause
   *            The cause of the exception.
   * @param parameters
   *            The optional parameters for the message.
   */
  protected SubscriptionException(String message, Throwable cause, Object... parameters) {
    super(message, cause, parameters);
  }

  /**
   * Create an exception.
   * 
   * @param message
   *            The exception message.
   * @param parameters
   *            The optional parameters for the message.
   */
  protected SubscriptionException(String message, Object... parameters) {
    super(message, parameters);
  }

  @Override
  public int getRestStatusCode() {
    return HttpStatus.SC_FORBIDDEN;
  }
}