/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job;

import com.ibm.optim.oaas.client.OperationException;
import com.ibm.optim.oaas.client.job.impl.JobMessageCodes;

/**
 * Validation exception thrown when the application was not set and the combination of attachments is
 * not recognized as valid for any application.
 */
public class UnrecognizedAttachmentsException extends ValidationException {
  private static final long serialVersionUID = -1;

  public UnrecognizedAttachmentsException(Object[] params,
                                          OperationException e) {
    super(JobMessageCodes.AKCJC5124E_UNRECOGNIZED_ATTACHMENTS_EXCEPTION.name(), e, params);
  }

  public UnrecognizedAttachmentsException() {
    super(JobMessageCodes.AKCJC5124E_UNRECOGNIZED_ATTACHMENTS_EXCEPTION.name());
  }
}