/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.impl;

import org.apache.http.impl.client.CloseableHttpClient;

import com.ibm.optim.oaas.client.http.HttpClientFactory;
import com.ibm.optim.oaas.client.impl.Validate;
import com.ibm.optim.oaas.client.job.JobClientBuilder;

public class JobClientBuilderImpl implements JobClientBuilder {
  private String baseURL;
  private CloseableHttpClient httpClient;
  private String clientid;
  private String secret;

  public JobClientBuilderImpl(String baseURL, String clientid, String secret) {
    Validate.notNull(baseURL, "baseURL");
    Validate.notNull(clientid, "clientid");
    this.baseURL = baseURL;
    this.clientid=clientid;
    this.secret=secret;
  }

  public JobClientBuilder http(CloseableHttpClient httpClient) {
    Validate.notNull(httpClient, "httpClient");
    this.httpClient = httpClient;
    return this;
  }

  public JobClientImpl build() {
    CloseableHttpClient httpClientConfig = httpClient;
    if (httpClientConfig == null) {
      httpClientConfig = HttpClientFactory.createDefault();
    }
    return new JobClientImpl(httpClientConfig, baseURL, clientid, secret);
  }
}