/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.impl;

import java.io.IOException;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.optim.oaas.client.OperationException;
import com.ibm.optim.oaas.client.job.AttachmentNotFoundException;
import com.ibm.optim.oaas.client.job.JobClient;
import com.ibm.optim.oaas.client.job.JobNotFoundException;

public class JobJsonOutputImpl<T> extends JobOutputImpl {
  private ObjectMapper mapper;
  private TypeReference<T> type;
  private Class<T> typeClass;
  private T obj;

  public JobJsonOutputImpl(ObjectMapper mapper, TypeReference<T> type) {
    this.mapper = mapper;
    this.type = type;
  }

  public JobJsonOutputImpl(ObjectMapper mapper, Class<T> type) {
    this.mapper = mapper;
    this.typeClass = type;
  }

  public JobJsonOutputImpl(String attid, ObjectMapper mapper, Class<T> type) {
    super(attid);
    this.mapper = mapper;
    this.typeClass = type;
  }

  public JobJsonOutputImpl(String attid, ObjectMapper mapper, TypeReference<T> type) {
    super(attid);
    this.mapper = mapper;
    this.type = type;
  }

  @Override
  public T getContent() {
    return obj;
  }

  @Override
  public void download(JobClient client, String jobid) throws JobNotFoundException,
  AttachmentNotFoundException,
  OperationException, IOException {
    if (typeClass != null) {
      obj = client.downloadJobAttachment(jobid, getName(), mapper, typeClass);
    } else {
      obj = client.downloadJobAttachment(jobid, getName(), mapper, type);
    }
  }

}
