/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.impl;

import java.io.IOException;

import com.ibm.optim.oaas.client.OperationException;
import com.ibm.optim.oaas.client.job.JobClient;
import com.ibm.optim.oaas.client.job.JobLogOutput;
import com.ibm.optim.oaas.client.job.JobNotFoundException;

public abstract class JobLogOutputImpl implements JobLogOutput {
  public JobLogOutputImpl() {
  }

  /**
   * Indicates if the upload can be repeated.
   * 
   * @return
   */
  public abstract boolean isRepeatable();

  public abstract void download(JobClient client, String jobid)
      throws JobNotFoundException, OperationException, IOException;
}