/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.impl;

import com.ibm.optim.oaas.client.impl.OaasMessageCode;

//@IloMessageCodeConfiguration(prefix = "AKCJC", rangeMin = 5100, rangeMax = 5999)
public class JobMessageCodes extends OaasMessageCode {
  public static OaasMessageCode AKCJC5101E_JOB_NOT_FOUND_EXCEPTION;
  public static OaasMessageCode AKCJC5102E_ATTACHMENT_NOT_FOUND_EXCEPTION;
  public static OaasMessageCode AKCJC5103E_ATTACHMENT_BLOB_NOT_FOUND_EXCEPTION;

  public static OaasMessageCode AKCJC5110E_UNDEFINED_SUBSCRIPTION_EXCEPTION;
  public static OaasMessageCode AKCJC5111E_JOB_LIMIT_EXCEPTION;
  public static OaasMessageCode AKCJC5112E_ATTACHMENT_STORAGE_LIMIT_EXCEPTION;
  public static OaasMessageCode AKCJC5113E_STORAGE_LIMIT_EXCEPTION;

  public static OaasMessageCode AKCJC5120E_UNDEFINED_APPLICATION_EXCEPTION;
  public static OaasMessageCode AKCJC5121E_INVALID_APPLICATION_EXCEPTION;
  public static OaasMessageCode AKCJC5122E_INVALID_ATTACHMENTS_EXCEPTION;
  public static OaasMessageCode AKCJC5123E_MISSING_ATTACHMENTS_EXCEPTION;
  public static OaasMessageCode AKCJC5124E_UNRECOGNIZED_ATTACHMENTS_EXCEPTION;
  public static OaasMessageCode AKCJC5125E_MISSING_EXTENSION_EXCEPTION;
  public static OaasMessageCode AKCJC5126E_JOB_STATUS_EXCEPTION;
  public static OaasMessageCode AKCJC5127E_PROCESSING_OWNER_EXCEPTION;
  public static OaasMessageCode AKCJC5128E_FORMAT_NOT_SUPPORTED_EXCEPTION;
  public static OaasMessageCode AKCJC5129E_INVALID_ATTACHMENT_NAME_EXCEPTION;
  public static OaasMessageCode AKCJC5130E_EMPTY_ATTACHMENT_EXCEPTION;
  public static OaasMessageCode AKCJC5131E_MISSING_ATTACHMENT_NAME_EXCEPTION;

  public static OaasMessageCode AKCJC5201I_JOB_CREATED;
  public static OaasMessageCode AKCJC5202I_ATTACHMENT_UPLOADED;
  public static OaasMessageCode AKCJC5203I_JOB_SUBMITTED;
  public static OaasMessageCode AKCJC5204I_JOB_RUNNING;
  public static OaasMessageCode AKCJC5205I_JOB_PROCESSED;
  public static OaasMessageCode AKCJC5206I_JOB_FAILED;
  public static OaasMessageCode AKCJC5207I_JOB_INTERRUPTED;
  public static OaasMessageCode AKCJC5208F_ATTACHMENT_UPLOADING;
  public static OaasMessageCode AKCJC5209F_ATTACHMENT_DOWNLOADING;
  public static OaasMessageCode AKCJC5210I_ATTACHMENT_DOWNLOADED;
  public static OaasMessageCode AKCJC5211F_LOG_DOWNLOADING;
  public static OaasMessageCode AKCJC5212I_LOG_DOWNLOADED;
  public static OaasMessageCode AKCJC5213I_JOB_DELETED;
  public static OaasMessageCode AKCJC5214I_JOBS_DELETED;
  public static OaasMessageCode AKCJC5215I_JOB_ENDED;
  public static OaasMessageCode AKCJC5216W_JOB_MONITORING_TIMEOUT;
  public static OaasMessageCode AKCJC5240I_LOG_TOO_LARGE;
  public static OaasMessageCode AKCJC5241I_LOG_ITEM_NOT_AVAILABLE;
  public static OaasMessageCode AKCJC5242I_LOG_JOB_NOT_COMPLETED;

  public static OaasMessageCode AKCJC5300E_JOB_PROCESSED_NO_OUTPUT;
  public static OaasMessageCode AKCJC5301E_DEAD_JOB;
  public static OaasMessageCode AKCJC5302E_INTERNAL_EXCEPTION;

  static {
    initializeCodes(JobMessageCodes.class, JobMessageCodes.class.getPackage().getName());
  }
}
