/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.impl;

import java.util.ArrayList;
import java.util.List;

import com.ibm.optim.oaas.client.impl.Validate;
import com.ibm.optim.oaas.client.job.JobOutput;
import com.ibm.optim.oaas.client.job.JobResponse;
import com.ibm.optim.oaas.client.job.model.impl.JobCreationDataImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobImpl;

public class JobResponseImpl implements JobResponse {
  private String jobid;
  private JobClientImpl client;
  private JobCreationDataImpl data;
  private List<JobOutput> output = new ArrayList<JobOutput>();
  private List<JobLogOutputImpl> logoutput = new ArrayList<JobLogOutputImpl>();
  private JobImpl job;

  public JobResponseImpl(JobClientImpl client, JobCreationDataImpl data,
                         List<JobOutput> output, List<JobLogOutputImpl> logoutput) {
    Validate.notNull(client, "client");
    Validate.notNull(data, "data");
    this.client = client;
    this.data = data;
    this.output = output;
    this.logoutput = logoutput;
  }

  public void setJobId(String jobid) {
    this.jobid = jobid;
  }

  @Override
  public List<JobOutput> getOutput() {
    return output;
  }

  @Override
  public List<JobLogOutputImpl> getLogOutput() {
    return logoutput;
  }

  @Override
  public JobClientImpl getClient() {
    return client;
  }

  @Override
  public String getJobId() {
    return jobid;
  }

  @Override
  public JobImpl getJob() {
    return job;
  }

  public void setJob(JobImpl job){
    this.job=job;
  }


  @Override
  public JobCreationDataImpl getData() {
    return data;
  }
}
