/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import com.ibm.optim.oaas.client.OperationException;
import com.ibm.optim.oaas.client.job.AttachmentNotFoundException;
import com.ibm.optim.oaas.client.job.JobClient;
import com.ibm.optim.oaas.client.job.JobNotFoundException;
import com.ibm.optim.oaas.client.job.SubscriptionException;

public class JobURLInputImpl extends JobInputImpl {
  private URL url;

  public JobURLInputImpl(String name, URL url) {
    super(name);
    this.url = url;
  }

  @Override
  public long getLength() {
    return -1;
  }

  @Override
  public void upload(JobClient client, String jobid)
      throws OperationException, IOException, JobNotFoundException,
      AttachmentNotFoundException, SubscriptionException {
    InputStream stream = url.openStream();
    try {
      client.uploadJobAttachment(jobid, getName(), stream);
    } finally {
      if (stream != null)
        stream.close();
    }

  }

  @Override
  public boolean isRepeatable() {
    return true;
  }
}
