/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Job API client information.  The API client information is available
 * when the job was submitted using the API.
 */
@ApiModel(value = "JobApiClient", description = "Job API client information")
public interface JobApiClient {
  /**
   * Gets the client ID used to create this job.
   * 
   * @return The client ID.
   */
  @ApiModelProperty(value = "The client ID", required = false)
  public abstract String getId();

  /**
   * Gets the client name specified for this job. The client name
   * may be used to distinguish between different clients using the same
   * subscription.
   * 
   * @return The client name.
   */
  @ApiModelProperty(value = "The client name", required = false)
  public abstract String getName();

  /**
   * Gets the email address specified for this job.
   * 
   * @return The client email.
   */
  @ApiModelProperty(value = "The client email", required = false)
  public abstract String getEmail();
}
