/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Attachment to a job.
 */
@ApiModel(value = "JobAttachment", description = "Attachment to a job")
public interface JobAttachment {
  /**
   * Gets the name of the attachment.
   * 
   * @return The name of the attachment.
   */
  @ApiModelProperty(value = "The name of the job attachment", required = true)
  public abstract String getName();

  /**
   * Gets attachment type, indicating if the attachment is for input or output.
   * 
   * @return The type of the attachment.
   */
  @ApiModelProperty(value = "The type of the job attachment", required = true)
  public abstract JobAttachmentType getType();

  /**
   * Gets the size of the attachment.
   * 
   * @return The attachment length.
   */
  @ApiModelProperty(value = "The job attachment length")
  public abstract long getLength();

}
