/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Detailed information about a job failure, with the type of failure as well as
 * a message describing the failure.
 */
@ApiModel(value = "JobFailureInfo", description = "Job failure information")
public interface JobFailureInfo {
  /**
   * Gets the job failure type.
   * 
   * @return The failure type.
   */
  @ApiModelProperty(value = "Job failure type", required = true)
  public abstract JobFailureType getType();

  /**
   * Gets a message describing the job failure.
   * 
   * @return Job failure message.
   */
  @ApiModelProperty(value = "Job failure message")
  public abstract String getMessage();
}