/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model;

/**
 * Enumeration of possible job failure types.
 */
public enum JobFailureType {
  /**
   * Failure type is unknown.
   */
  UNKNOWN,

  /**
   * Infrastructure type. This error type is raised in the case of database,
   * JMS, server, or similar types of issues. These are internal issues that
   * are not associated with an end user.
   */
  INFRASTRUCTURE,

  /**
   * Processing type. This error type is raised in case of solve issues. This
   * includes issues with an invalid model or with input files etc. These are
   * business level issues that can be reported to an end user.
   */
  PROCESSING;
}