/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model;

/**
 * Enumeration describing the interruption status of executing a job.
 */
public enum JobInterruptionStatus {
  /**
   * The job was interrupted using a manual call (by a user or administrator).
   */
  STOP,

  /**
   * The job process was stopped in the quickest possible manner manually (by
   * a user or administrator).
   */
  KILL,

  /**
   * The job processing was stopped because the timeout limit was reached. The
   * limit is either explicitly set by a user or is taken from the default
   * timeout value defined in the subscription.
   */
  TIMEOUT,

  /**
   * The job was stopped because the job process reached the maximum allowed
   * memory usage, as defined in the subscription.
   */
  OUT_OF_MEMORY;
}