/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Class representing a record in the log for a job.
 */
@ApiModel(value = "JobLogRecord", description = "Job log record")
public interface JobLogRecord {
  /**
   * Gets the message of the job log record.
   * 
   * @return The message value.
   */
  @ApiModelProperty(value = "Detailed log message")
  public abstract String getMessage();

  /**
   * Gets the time of the job log record.
   * 
   * @return The job log record time.
   */
  @ApiModelProperty(value = "The time of logged event", dataType = "long")
  public abstract Date getDate();

  /**
   * Gets the log level of the job log record.
   * 
   * @return The log level.
   */
  @ApiModelProperty(value = "The log level", allowableValues = "SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST")
  public abstract String getLevel();

}
