/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model;

/**
 * Enumeration of possible solve status values.
 */
public enum JobSolveStatus {
  /**
   * Specifies that the algorithm has no information about the solution of the
   * model.
   */
  UNKNOWN,

  /**
   * Specifies that the algorithm found a feasible solution. A feasible
   * solution is one in which values are assigned to all variables, and all
   * model constraints are satisfied, but it is not necessarily an optimal
   * solution.
   */
  FEASIBLE_SOLUTION,

  /**
   * Specifies that the algorithm found an optimal solution. An optimal
   * solution is one in which values are assigned to all variables, and all
   * model constraints are satisfied, and it has been proven to be an optimal
   * solution with respect to the model objective.
   * 
   */
  OPTIMAL_SOLUTION,

  /**
   * Specifies that the algorithm proved that the model is infeasible. An
   * infeasible model is one in which it is not possible to assign values to
   * variables such that all the constraints in the model can be satisfied.
   */
  INFEASIBLE_SOLUTION,

  /**
   * Specifies that the algorithm proved the model unbounded.
   */
  UNBOUNDED_SOLUTION,

  /**
   * Specifies that the model is infeasible or unbounded.
   */
  INFEASIBLE_OR_UNBOUNDED_SOLUTION;
}