/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Job subscriber information. The job subscriber information is available
 * when the job was submitted using the DropSolve.
 */
@ApiModel(value = "JobSubscriber", description = "Job subscriber information")
public interface JobSubscriber {
  /**
   * Gets the IBM ID of the subscriber.
   * 
   * @return The subscriber ID.
   */
  @ApiModelProperty(value = "The subscriber IBM ID", required = true)
  public abstract String getIBMId();

  /**
   * Gets name of the subscriber.
   * 
   * @return The subscriber name.
   */
  @ApiModelProperty(value = "The subscriber name", required = true)
  public abstract String getName();

  /**
   * Gets email address of the subscriber.
   * 
   * @return The subscriber email.
   */
  @ApiModelProperty(value = "The subscriber email", required = true)
  public abstract String getEmail();
}
