/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.ibm.optim.oaas.client.job.model.JobAttachment;
import com.ibm.optim.oaas.client.job.model.JobAttachmentCreationData;
import com.ibm.optim.oaas.client.job.model.JobAttachmentType;
import com.ibm.optim.oaas.client.job.model.impl.DocumentImpl.StorageView;

/**
 * Attachment to a job.
 */
@JsonAutoDetect(fieldVisibility = Visibility.ANY, getterVisibility = Visibility.NONE, setterVisibility = Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class JobAttachmentImpl implements JobAttachment, JobAttachmentCreationData {
  private String name;
  private JobAttachmentType type = JobAttachmentType.INPUT_ATTACHMENT;
  private long length;

  @JsonView(StorageView.class)
  private String storageId;

  @JsonIgnore
  private boolean ignoreSize;

  /**
   * 
   */
  public JobAttachmentImpl() {
  }

  public JobAttachmentImpl(String name) {
    this.name = name;
  }

  public JobAttachmentImpl(String name, JobAttachmentType type) {
    this.name = name;
    this.type = type;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.JobAttachment#getName()
   */
  @Override
  public String getName() {
    return name;
  }

  /*
   * (non-Javadoc)
   * 
   * @see
   * com.ibm.optim.oaas.client.job.model.JobAttachment#setName(java.lang.String
   * )
   */
  @Override
  public void setName(String name) {
    this.name = name;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.JobAttachment#getType()
   */
  @Override
  public JobAttachmentType getType() {
    return type;
  }

  public void setType(JobAttachmentType type) {
    this.type = type;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.JobAttachment#getLength()
   */
  @Override
  public long getLength() {
    return length;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.JobAttachment#setLength(long)
   */
  @Override
  public void setLength(long length) {
    this.length = length;
  }

  public String getStorageId() {
    return storageId;
  }

  public void setStorageId(String storageId) {
    this.storageId = storageId;
  }

  public boolean isIgnoreSize() {
    return ignoreSize;
  }

  public void setIgnoreSize(boolean ignoreSize) {
    this.ignoreSize = ignoreSize;
  }


}
