/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model.impl;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ibm.optim.oaas.client.job.model.JobAttachmentCreationData;
import com.ibm.optim.oaas.client.job.model.JobCreationData;
import com.ibm.optim.oaas.client.job.model.JobParameters;

@JsonAutoDetect(fieldVisibility = Visibility.ANY, getterVisibility = Visibility.NONE, setterVisibility = Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class JobCreationDataImpl implements JobCreationData {
  private String applicationId;
  private String applicationVersion;
  private String clientName;

  private JobParametersImpl parameters = new JobParametersImpl();

  private List<JobAttachmentImpl> attachments = new ArrayList<JobAttachmentImpl>();

  private String email;


  @JsonIgnore
  private boolean ignoreJobCount;

  public JobCreationDataImpl() {

  }

  /*
   * (non-Javadoc)
   * 
   * @see
   * com.ibm.optim.oaas.client.job.model.JobCreationData#getApplicationId()
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /*
   * (non-Javadoc)
   * 
   * @see
   * com.ibm.optim.oaas.client.job.model.JobCreationData#setApplicationId(java
   * .lang.String)
   */
  @Override
  public void setApplicationId(String applicationId) {
    this.applicationId = applicationId;
  }

  /*
   * (non-Javadoc)
   * 
   * @see
   * com.ibm.optim.oaas.client.job.model.JobCreationData#getApplicationVersion
   * ()
   */
  @Override
  public String getApplicationVersion() {
    return applicationVersion;
  }

  /*
   * (non-Javadoc)
   * 
   * @see
   * com.ibm.optim.oaas.client.job.model.JobCreationData#setApplicationVersion
   * (java.lang.String)
   */
  @Override
  public void setApplicationVersion(String applicationVersion) {
    this.applicationVersion = applicationVersion;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.JobCreationData#getParameters()
   */
  @Override
  public JobParameters getParameters() {
    return parameters;
  }

  /**
   * Swagger does not generate the doc of "? extends" so doing a trick.
   */
  @SuppressWarnings("unchecked")
  @Override
  public List<JobAttachmentCreationData> getAttachments() {
    List<?> list =  attachments;
    return (List<JobAttachmentCreationData>) list;
  }

  public List<JobAttachmentImpl> getImplAttachments() {
    return attachments;
  }



  @Override
  public JobAttachmentImpl addJobAttachment(String name) {
    JobAttachmentImpl att = new JobAttachmentImpl(name);
    attachments.add(att);
    return att;
  }

  @Override
  public void setClientName(String name) {
    this.clientName=name;		
  }

  @Override
  public String getClientName() {
    return this.clientName;
  }

  @Override
  public void setClientEmail(String email) {
    this.email = email;
  }

  @Override
  public String getClientEmail() {
    return email;
  }

  public boolean isIgnoreJobCount() {
    return ignoreJobCount;
  }

  public void setIgnoreJobCount(boolean ignoreJobCount) {
    this.ignoreJobCount = ignoreJobCount;
  }

  @Override
  public JobAttachmentImpl getAttachment(String name) {
    for (JobAttachmentImpl att : attachments) {
      if (att.getName().equals(name)) {
        return att;
      }
    }
    return null;
  }

}
