/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model.impl;

import java.util.Date;
import java.util.Map;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;

@JsonAutoDetect(fieldVisibility = Visibility.ANY, getterVisibility = Visibility.NONE, setterVisibility = Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class JobDetailsImpl extends JobElementImpl {
  public final static long MISSING_TIMEOUT = 10000;

  public final static String TYPE = "details";

  public static String getIdFromJob(String jobid, long seq) {
    if (seq >= 0) {
      return TYPE+"."+jobid+"."+seq;
    } else {
      return TYPE+"."+jobid+"."+UUID.randomUUID();
    }
  }

  @JsonView(StorageView.class)
  @JsonProperty("type")
  private String type = TYPE;

  private Date date;
  private Map<String, String> details;
  private Map<String, String> systemDetails;

  public Date getDate() {
    return date;
  }

  public void setDate(Date date) {
    this.date = date;
  }

  public Map<String, String> getDetails() {
    return details;
  }

  public void setDetails(Map<String, String> details) {
    this.details = details;
  }

  public Map<String, String> getSystemDetails() {
    return systemDetails;
  }

  public void setSystemDetails(Map<String, String> systemDetails) {
    this.systemDetails = systemDetails;
  }
}
