/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ibm.optim.oaas.client.job.model.JobFailureInfo;
import com.ibm.optim.oaas.client.job.model.JobFailureType;

@JsonAutoDetect(fieldVisibility = Visibility.ANY, getterVisibility = Visibility.NONE, setterVisibility = Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class JobFailureInfoImpl implements JobFailureInfo {
  private JobFailureType type;
  private String message;

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.JobFailureInfo#getType()
   */
  @Override
  public JobFailureType getType() {
    return type;
  }

  public void setType(JobFailureType type) {
    this.type = type;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.JobFailureInfo#getMessage()
   */
  @Override
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.JobFailureInfo#toString()
   */
  @Override
  public String toString() {

    StringBuilder sb = new StringBuilder(super.toString() + " :\n");
    sb.append("\tMessage : " + message + "\n");
    sb.append("\tType : " + type + "\n");
    return sb.toString();

  }

}
