/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.ibm.optim.oaas.client.job.model.JobLogItem;
import com.ibm.optim.oaas.client.job.model.JobLogRecord;

@JsonAutoDetect(fieldVisibility = Visibility.ANY, getterVisibility = Visibility.NONE, setterVisibility = Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class JobLogItemImpl extends JobElementImpl implements JobLogItem {
  public final static long  MISSING_TIMEOUT = 10000;

  public final static String TYPE = "log";

  @JsonView(StorageView.class)
  @JsonProperty("type")
  private String type = TYPE;

  private long seqid;

  private List<JobLogRecordImpl> records = new ArrayList<JobLogRecordImpl>();

  private Boolean missing;

  private Boolean stop;

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.JobLogItem#getSeqid()
   */
  @Override
  public long getSeqid() {
    return seqid;
  }

  public void setSeqid(long seqid) {
    this.seqid = seqid;
  }

  /**
   * Swagger does not generate the doc of "? extends" so doing a trick.
   */
  @SuppressWarnings("unchecked")
  @Override
  public List<JobLogRecord> getEngineLogRecords() {
    List<?> list = records;
    return (List<JobLogRecord>)list;
  }


  public List<JobLogRecordImpl> getImplEngineLogRecords() {
    return records;
  }

  public void setEngineLogRecords(List<JobLogRecordImpl> engineLogRecords) {
    this.records = engineLogRecords;
  }

  public void addRecord(Date date, String level, String message) {
    records.add(new JobLogRecordImpl(date, level, message));
  }

  @Override
  public boolean missing() {
    return missing==null?false:missing;
  }

  public void setMising(boolean missing){
    this.missing=missing;
  }

  public Date getDate(){
    if (records.isEmpty()) 
      return null;
    else
      return records.get(0).getDate();
  }

  @Override
  public boolean stop() {
    return stop==null?false:stop;
  }

  public void setStop(boolean stop){
    this.stop=stop;
  }
}
