/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model.impl;

import java.util.Date;
import java.util.logging.Level;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ibm.optim.oaas.client.job.model.JobLogRecord;

@JsonAutoDetect(fieldVisibility = Visibility.ANY, getterVisibility = Visibility.NONE, setterVisibility = Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class JobLogRecordImpl implements JobLogRecord {
  private Date date;
  private String level;
  private String message;

  public JobLogRecordImpl() {
  }

  public JobLogRecordImpl(Date date, Level level, String message) {
    this.date = date;
    this.level = level == null ? null : level.toString();
    this.message = message;
  }

  public JobLogRecordImpl(Date date, String level, String message) {
    this.date = date;
    this.level = level;
    this.message = message;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.LogRecord#getMessage()
   */
  @Override
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.LogRecord#getDate()
   */
  @Override
  public Date getDate() {
    return date;
  }

  public void setDate(Date date) {
    this.date = date;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.LogRecord#getLevel()
   */
  @Override
  public String getLevel() {

    return level;

  }

  public void setLevel(String level) {

    this.level = level;

  }
}
