/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map.Entry;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.ibm.optim.oaas.client.job.model.JobParameters;

public class JobParametersDeserializer extends JsonDeserializer<JobParameters> {
  @Override
  public JobParameters deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
    JsonNode node = jp.getCodec().readTree(jp);
    JobParametersImpl parameters = new JobParametersImpl();
    for (Iterator<Entry<String, JsonNode>> it = node.fields(); it.hasNext();) {
      Entry<String, JsonNode> p = it.next();
      if (p.getValue()!=null && !p.getValue().isNull()) {
        if (p.getValue().isBoolean()){
          parameters.put(p.getKey(), p.getValue().asBoolean());		
        } else if (p.getValue().isFloatingPointNumber()) {
          parameters.put(p.getKey(), p.getValue().asDouble());	
        } else if (p.getValue().isIntegralNumber()) {
          parameters.put(p.getKey(), p.getValue().asLong());	
        } else {
          parameters.put(p.getKey(), p.getValue().asText());		
        }	        	 
      }
    }
    return parameters;
  }
}