/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model.impl;

import java.util.HashMap;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.optim.oaas.client.job.model.JobParameters;

@JsonDeserialize(using = JobParametersDeserializer.class)
@JsonSerialize(using = JobParametersSerializer.class)
public class JobParametersImpl  extends HashMap<String,Object> implements JobParameters {
  private static final long serialVersionUID = 1L;

  @Override
  public Long getTimeLimit() {
    return getAsLong(TIME_LIMIT);
  }

  @Override
  public void setTimeLimit(Long value) {
    put(TIME_LIMIT, value);		
  }

  @Override
  public Long getLogLimit() {
    return getAsLong(LOG_LIMIT);
  }

  @Override
  public void setLogLimit(Long value) {
    put(LOG_LIMIT, value);		
  }

  @Override
  public String getOplRunConfig() {
    return getAsString(OPL_RUN_CONFIG);
  }

  @Override
  public void setOplRunConfig(String value) {
    put(OPL_RUN_CONFIG, value);		
  }

  @Override
  public String getResultsFormat() {
    return getAsString(RESULTS_FORMAT);
  }

  @Override
  public void setResultsFormat(String value) {
    put(RESULTS_FORMAT, value);		
  }

  @Override
  public String getWebhook() {
    return getAsString(WEBHOOK);
  }

  @Override
  public void setWebhook(String value) {
    put(WEBHOOK, value);		
  }

  @Override
  public Boolean getDropSolve() {
    return getAsBoolean(DROPSOLVE);
  }

  @Override
  public Boolean getNotifyCompletion() {
    return getAsBoolean(NOTIFY_COMPLETION);
  }

  @Override
  public void setNotifyCompletion(Boolean notify) {
    put(NOTIFY_COMPLETION,notify);
  }

  @Override
  public Long getAlertTime() {
    return getAsLong(ALERT_TIME);
  }

  @Override
  public Integer getJobCores() {
    return getAsInteger(JOB_CORES);
  }

  @Override
  public void setJobCores(Integer cores) {
    put(JOB_CORES, cores);
  }

  @Override
  public Integer getJobMemoryMbytes() {
    return getAsInteger(JOB_MEMORY_MBYTES);
  }

  @Override
  public void setJobMemoryMbytes(Integer mbytes) {
    put(JOB_MEMORY_MBYTES, mbytes);
  }

  @Override
  public String getBluemixRegion() {
    return getAsString(BLUEMIX_REGION);
  }

  @Override
  public void setBluemixRegion(String bluemixRegion) {
    put(BLUEMIX_REGION, bluemixRegion);
  }

  @Override
  public void setAlertTime(Long value) {
    put(ALERT_TIME,value);		
  }

  @Override
  public Boolean getAsBoolean(String name) {
    Object p = get(name);
    if (p == null) return null;
    if (p instanceof Boolean) return (Boolean) p;
    return Boolean.parseBoolean(p.toString());
  }

  @Override
  public String getAsString(String name) {
    Object p = get(name);
    if (p == null) return null;
    return p.toString();
  }

  @Override
  public Double getAsDouble(String name) {
    Object p = get(name);
    if (p == null) return null;
    if (p instanceof Double) return ((Double) p).doubleValue();
    return Double.parseDouble(p.toString());
  }

  @Override
  public Long getAsLong(String name) {
    Object p = get(name);
    if (p == null) return null;
    if (p instanceof Long) return ((Long) p).longValue();
    return Long.parseLong(p.toString());
  }

  @Override
  public Integer getAsInteger(String name) {
    Object p = get(name);
    if (p == null) return null;
    if (p instanceof Integer) return ((Integer) p).intValue();
    return Integer.parseInt(p.toString());
  }

  @Override
  public boolean getAsBoolean(String name, boolean defaultValue) {
    Object p = get(name);
    if (p == null) return defaultValue;
    if (p instanceof Boolean) return (Boolean) p;
    return Boolean.parseBoolean(p.toString());
  }

  @Override
  public String getAsString(String name, String defaultValue) {
    Object p = get(name);
    if (p == null) return defaultValue;
    return p.toString();
  }

  @Override
  public double getAsDouble(String name, double defaultValue) {
    Object p = get(name);
    if (p == null) return defaultValue;
    if (p instanceof Double) return ((Double) p).doubleValue();
    return Double.parseDouble(p.toString());
  }

  @Override
  public long getAsLong(String name, long defaultValue) {
    Object p = get(name);
    if (p == null) return defaultValue;
    if (p instanceof Long) return ((Long) p).longValue();
    return Long.parseLong(p.toString());
  }

  @Override
  public int getAsInteger(String name, int defaultValue) {
    Object p = get(name);
    if (p == null) return defaultValue;
    if (p instanceof Integer) return ((Integer) p).intValue();
    return Integer.parseInt(p.toString());
  }
}