/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model.impl;

import java.io.IOException;
import java.util.Map.Entry;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.ibm.optim.oaas.client.job.model.JobParameters;

public class JobParametersSerializer extends JsonSerializer<JobParameters> {
  @Override
  public void serialize(JobParameters value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
    jgen.writeStartObject();
    for (Entry<String, Object> entry : value.entrySet()) {
      if (entry.getValue() == null) {
        jgen.writeNullField(entry.getKey());
      } else if (entry.getValue() instanceof Double || entry.getValue() instanceof Float ) {
        jgen.writeNumberField(entry.getKey(), ((Number)entry.getValue()).doubleValue());	
      } else if (entry.getValue() instanceof Long || entry.getValue() instanceof Integer || entry.getValue() instanceof Short || entry.getValue() instanceof Byte) {
        jgen.writeNumberField(entry.getKey(), ((Number)entry.getValue()).longValue());	
      } else if (entry.getValue() instanceof Boolean){
        jgen.writeBooleanField(entry.getKey(), ((Boolean)entry.getValue()));	
      } else {
        jgen.writeStringField(entry.getKey(), entry.getValue().toString());	
      }
    }        
    jgen.writeEndObject();
  }
}