/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ibm.optim.oaas.client.job.model.JobExecutionStatus;
import com.ibm.optim.oaas.client.job.model.JobStatus;

@JsonAutoDetect(fieldVisibility = Visibility.ANY, getterVisibility = Visibility.NONE, setterVisibility = Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class JobStatusImpl implements JobStatus {
  private JobExecutionStatus executionStatus;

  public JobStatusImpl() { 
  }

  public JobStatusImpl(JobExecutionStatus executionStatus) {
    this.executionStatus=executionStatus;
  }

  /* (non-Javadoc)
   * @see com.ibm.optim.oaas.client.job.model.impl.JobStatus#getExecutionStatus()
   */
  @Override
  public JobExecutionStatus getExecutionStatus() {
    return this.executionStatus;
  }

  public void setExecutionStatus(JobExecutionStatus status) {
    this.executionStatus = status;
  }
}