/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.optim.oaas.client.job.model.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ibm.optim.oaas.client.job.model.JobSubscription;

@JsonAutoDetect(fieldVisibility = Visibility.ANY, getterVisibility = Visibility.NONE, setterVisibility = Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class JobSubscriptionImpl implements JobSubscription {
  private String type;
  private String id;
  private String customerId;
  private String customerIBMId;
  private int maxNumberOfParallelSolves = -1;
  private String planId = null;
  private String bluemixRegion = null;

  public JobSubscriptionImpl() {
  }

  public JobSubscriptionImpl(String subscriptionType, String subscriptionId) {
    type = subscriptionType;
    id = subscriptionId;
  }

  public JobSubscriptionImpl(final String subscriptionType,
                             final String subscriptionId,
                             final String customerId,
                             final String customerIBMid,
                             final int maxNumberOfParallelSolves,
                             final String planId,
                             final String bluemixRegion) {
    type = subscriptionType;
    id = subscriptionId;
    this.customerId = customerId;
    this.customerIBMId = customerIBMid;
    this.maxNumberOfParallelSolves = maxNumberOfParallelSolves;
    setPlanId(planId);
    setBluemixRegion(bluemixRegion);
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.JobSubscription#getType()
   */
  @Override
  public String getType() {
    return type;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.JobSubscription#setType(java.lang .String)
   */
  public void setType(String type) {
    this.type = type;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.JobSubscription#getId()
   */
  @Override
  public String getId() {
    return id;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.JobSubscription#setId(java.lang.String )
   */
  public void setId(String id) {
    this.id = id;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.ibm.optim.oaas.client.job.model.JobSubscription#toString()
   */
  @Override
  public String toString() {
    StringBuffer buffer = new StringBuffer();
    buffer.append("[");
    buffer.append(type);
    buffer.append(":");
    buffer.append(id);
    buffer.append("]");
    return buffer.toString();
  }

  @Override
  public String getCustomerId() {
    return customerId;
  }

  public int getMaxNumberOfParallelSolves() {
    return maxNumberOfParallelSolves;
  }

  public void setMaxNumberOfParallelSolves(int maxNumberOfParallelSolves) {
    this.maxNumberOfParallelSolves = maxNumberOfParallelSolves;
  }

  public String getCustomerIBMId() {
    return customerIBMId;
  }

  public String getPlanId() {
    return planId;
  }

  public void setPlanId(String planId) {
    this.planId = planId;
  }

  public String getBluemixRegion() {
    return bluemixRegion;
  }

  public void setBluemixRegion(String bluemixRegion) {
    this.bluemixRegion = bluemixRegion;
  }
}