/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.http;

import java.util.concurrent.TimeUnit;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpIdleConnectionMonitorThread
extends Thread {
    public static final int DEFAULT_IDLE_TIMEOUT = 120;
    public static final int DEFAULT_INTERVAL = 5;
    private final CloseableHttpClient client;
    private volatile boolean shutdown;
    private int interval = 5;
    private int idleTimeout = 120;

    public HttpIdleConnectionMonitorThread(CloseableHttpClient client) {
        this.client = client;
    }

    public HttpIdleConnectionMonitorThread(CloseableHttpClient client, int interval, int idleTimeout) {
        this.client = client;
        this.interval = interval;
        this.idleTimeout = idleTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                HttpIdleConnectionMonitorThread httpIdleConnectionMonitorThread = this;
                synchronized (httpIdleConnectionMonitorThread) {
                    this.wait(this.interval * 1000);
                    this.client.getConnectionManager().closeExpiredConnections();
                    this.client.getConnectionManager().closeIdleConnections((long)this.idleTimeout, TimeUnit.SECONDS);
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        HttpIdleConnectionMonitorThread httpIdleConnectionMonitorThread = this;
        synchronized (httpIdleConnectionMonitorThread) {
            this.notifyAll();
        }
    }
}

