/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.job;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.ibm.optim.oaas.client.OaasException;
import com.ibm.optim.oaas.client.http.HttpClientFactory;
import com.ibm.optim.oaas.client.impl.ClientMessageCodes;
import com.ibm.optim.oaas.client.job.JobClient;
import com.ibm.optim.oaas.client.job.JobClientBuilder;
import com.ibm.optim.oaas.client.job.impl.JobClientBuilderImpl;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JobClientFactory {
    public static final String BLUEMIX_SERVICE_LABEL = "docplexcloud";
    private static final String BLUEMIX_PROPERTY_NAME = "name";
    private static final String BLUEMIX_PROPERTY_LABEL = "label";
    private static final Logger logger = Logger.getLogger(JobClientFactory.class.getName());
    private static final ObjectReader objectReader;

    public static JobClient createDefault(String baseURL, String clientid) {
        return new JobClientBuilderImpl(baseURL, clientid, null).http(HttpClientFactory.createDefault()).build();
    }

    public static JobClientBuilder custom(String baseURL, String clientid) {
        return new JobClientBuilderImpl(baseURL, clientid, null);
    }

    public static JobClientBuilder custom(String baseURL, String clientid, String secret) {
        return new JobClientBuilderImpl(baseURL, clientid, secret);
    }

    public static JobClient createDefault(String baseURL, String clientid, String secret) {
        return new JobClientBuilderImpl(baseURL, clientid, secret).build();
    }

    private static String[] getBluemixCredentials(JsonNode node) {
        String subscriptionId;
        if (node == null) {
            return null;
        }
        JsonNode nurl = node.get("url");
        JsonNode nclient_id = node.get("client_id");
        JsonNode nsubscriptionId = node.get("subscriptionId");
        String url = nurl != null ? nurl.textValue() : null;
        String client_id = nclient_id != null ? nclient_id.textValue() : null;
        String string = subscriptionId = nsubscriptionId != null ? nsubscriptionId.textValue() : null;
        if (url != null && client_id != null) {
            if (subscriptionId != null) {
                return new String[]{url, client_id, subscriptionId};
            }
            return new String[]{url, client_id};
        }
        return null;
    }

    private static String[] getBluemixCredentials(String name) throws OaasException {
        String vcapServices = System.getenv("VCAP_SERVICES");
        return JobClientFactory.getBluemixCredentials(vcapServices, name);
    }

    private static boolean matches(JsonNode node, String name) {
        String value;
        JsonNode n;
        return name != null ? (n = node.get(BLUEMIX_PROPERTY_NAME)) != null && name.equalsIgnoreCase(n.textValue()) : (n = node.get(BLUEMIX_PROPERTY_LABEL)) != null && (value = n.textValue()) != null && value.toLowerCase().startsWith(BLUEMIX_SERVICE_LABEL);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static String[] getBluemixCredentials(String vcapServices, String name) throws OaasException {
        if (vcapServices != null && !vcapServices.trim().isEmpty()) {
            try (LineNumberReader in = new LineNumberReader(new StringReader(vcapServices));){
                JsonNode vcap = objectReader.readTree((Reader)in);
                Iterator it = vcap.fields();
                while (it.hasNext()) {
                    String[] credentials;
                    Map.Entry entry = (Map.Entry)it.next();
                    if (entry.getValue() instanceof ArrayNode) {
                        ArrayNode arr = (ArrayNode)entry.getValue();
                        for (JsonNode node : arr) {
                            String[] credentials2;
                            if (!JobClientFactory.matches(node, name) || (credentials2 = JobClientFactory.getBluemixCredentials(node.get("credentials"))) == null) continue;
                            String[] stringArray = credentials2;
                            return stringArray;
                        }
                        continue;
                    }
                    if (!JobClientFactory.matches((JsonNode)entry.getValue(), name) || (credentials = JobClientFactory.getBluemixCredentials(((JsonNode)entry.getValue()).get("credentials"))) == null) continue;
                    String[] stringArray = credentials;
                    return stringArray;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
        String error = name != null ? name : "docplexcloud*";
        Object[] args = new Object[]{name != null ? BLUEMIX_PROPERTY_NAME : BLUEMIX_PROPERTY_LABEL, error};
        throw new OaasException(ClientMessageCodes.AKCJC5060E_BLUEMIX_CREDENTIALS_MISSING.name(), args){
            private static final long serialVersionUID = 1L;

            @Override
            protected String getResourceBundleName() {
                return ClientMessageCodes.class.getName();
            }
        };
    }

    public static JobClient createDefaultFromBluemix() throws OaasException {
        return JobClientFactory.createDefaultFromBluemix(null);
    }

    public static JobClient createDefaultFromBluemix(String serviceName) throws OaasException {
        String[] credentials = JobClientFactory.getBluemixCredentials(serviceName);
        return new JobClientBuilderImpl(credentials[0], credentials[1], null).http(HttpClientFactory.createDefault()).build();
    }

    public static JobClientBuilder customFromBluemix(String serviceName) throws OaasException {
        String[] credentials = JobClientFactory.getBluemixCredentials(serviceName);
        return new JobClientBuilderImpl(credentials[0], credentials[1], null);
    }

    public static JobClientBuilder customFromBluemix() throws OaasException {
        return JobClientFactory.customFromBluemix(null);
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        objectReader = mapper.reader();
    }
}

