/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.job.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.optim.oaas.client.OperationException;
import com.ibm.optim.oaas.client.ServerExceptionData;
import com.ibm.optim.oaas.client.impl.DeletionStatus;
import com.ibm.optim.oaas.client.impl.RestClient;
import com.ibm.optim.oaas.client.impl.Validate;
import com.ibm.optim.oaas.client.job.AttachmentContentWriter;
import com.ibm.optim.oaas.client.job.AttachmentNotFoundException;
import com.ibm.optim.oaas.client.job.AttachmentStorageLimitException;
import com.ibm.optim.oaas.client.job.EmptyAttachmentException;
import com.ibm.optim.oaas.client.job.FormatNotSupportedException;
import com.ibm.optim.oaas.client.job.IllegalJobStatusException;
import com.ibm.optim.oaas.client.job.InvalidApplicationException;
import com.ibm.optim.oaas.client.job.InvalidAttachmentNameException;
import com.ibm.optim.oaas.client.job.InvalidAttachmentsException;
import com.ibm.optim.oaas.client.job.JobClient;
import com.ibm.optim.oaas.client.job.JobLimitException;
import com.ibm.optim.oaas.client.job.JobNotFoundException;
import com.ibm.optim.oaas.client.job.MissingAttachmentsException;
import com.ibm.optim.oaas.client.job.StorageLimitException;
import com.ibm.optim.oaas.client.job.SubscriptionException;
import com.ibm.optim.oaas.client.job.UndefinedApplicationException;
import com.ibm.optim.oaas.client.job.UnrecognizedAttachmentsException;
import com.ibm.optim.oaas.client.job.ValidationException;
import com.ibm.optim.oaas.client.job.impl.JobMessageCodes;
import com.ibm.optim.oaas.client.job.impl.JobRequestBuilderImpl;
import com.ibm.optim.oaas.client.job.model.JobAttachmentCreationData;
import com.ibm.optim.oaas.client.job.model.JobAttachmentType;
import com.ibm.optim.oaas.client.job.model.JobCreationData;
import com.ibm.optim.oaas.client.job.model.JobExecutionStatus;
import com.ibm.optim.oaas.client.job.model.JobFailureInfo;
import com.ibm.optim.oaas.client.job.model.JobLogItem;
import com.ibm.optim.oaas.client.job.model.JobStatus;
import com.ibm.optim.oaas.client.job.model.impl.JobAttachmentImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobCreationDataImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobFailureInfoImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobLogItemImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobStatusImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class JobClientImpl
extends RestClient
implements JobClient {
    public JobClientImpl(CloseableHttpClient client, String url, String token) {
        super(client, url, token);
    }

    public JobClientImpl(CloseableHttpClient client, String url, String clientid, String secret) {
        super(client, url, clientid, secret);
    }

    @Override
    public void deleteAllJobs() throws OperationException {
        this.delete(this.getBaseUrl() + "jobs");
        JobMessageCodes.AKCJC5214I_JOBS_DELETED.log(new Object[0]);
    }

    public List<JobImpl> getAllJobs() throws OperationException {
        return this.getList(this.getBaseUrl() + "jobs", new TypeReference<List<JobImpl>>(){});
    }

    @Override
    public String createJob(JobCreationData data) throws OperationException, SubscriptionException, ValidationException {
        Validate.notNull(data, "data");
        try {
            String jobid = this.create(this.getBaseUrl() + "jobs", data);
            JobMessageCodes.AKCJC5201I_JOB_CREATED.log(jobid);
            return jobid;
        }
        catch (OperationException e) {
            this.checkSubscription(e);
            this.checkValidation(e);
            throw e;
        }
    }

    public String submitJob(JobCreationData data, Object ... atts) throws OperationException, SubscriptionException, ValidationException {
        Validate.notNull(data, "data");
        if (data.getAttachments().size() != atts.length) {
            throw new IllegalArgumentException("Invalid number of attachments specified.");
        }
        String[] name = new String[atts.length + 1];
        String[] filename = new String[atts.length + 1];
        boolean[] asJson = new boolean[atts.length + 1];
        Object[] obj = new Object[atts.length + 1];
        name[0] = "OaasJobCreationData";
        asJson[0] = true;
        obj[0] = data;
        for (int i = 0; i < data.getAttachments().size(); ++i) {
            JobAttachmentCreationData att = data.getAttachments().get(i);
            name[i + 1] = "OaasJobAttachment_" + i;
            filename[i + 1] = att.getName();
            asJson[i + 1] = false;
            obj[i + 1] = atts[i];
        }
        try {
            String jobid = this.createMultiPart(this.getBaseUrl() + "jobs/submit", name, filename, asJson, obj);
            JobMessageCodes.AKCJC5201I_JOB_CREATED.log(jobid);
            return jobid;
        }
        catch (OperationException e) {
            this.checkSubscription(e);
            this.checkValidation(e);
            throw e;
        }
    }

    @Override
    public String copyJob(String jobid, JobCreationData data, boolean shallow) throws OperationException, SubscriptionException, ValidationException, JobNotFoundException {
        Validate.notNull(jobid, "jobid");
        try {
            String newjobid = this.create(this.getBaseUrl() + "jobs/" + this.encodeName(jobid) + "/copy?shallow=" + shallow, data);
            JobMessageCodes.AKCJC5201I_JOB_CREATED.log(newjobid);
            return newjobid;
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            this.checkSubscription(e);
            this.checkValidation(e);
            throw e;
        }
    }

    @Override
    public String recreateJob(String jobid, JobCreationData data, boolean execute) throws OperationException, SubscriptionException, ValidationException, JobNotFoundException {
        Validate.notNull(jobid, "jobid");
        try {
            String newjobid = this.create(this.getBaseUrl() + "jobs/" + this.encodeName(jobid) + "/recreate?execute=" + execute, data);
            JobMessageCodes.AKCJC5201I_JOB_CREATED.log(newjobid);
            return newjobid;
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            this.checkSubscription(e);
            this.checkValidation(e);
            throw e;
        }
    }

    @Override
    public JobImpl getJob(String id) throws OperationException, JobNotFoundException {
        Validate.notNull(id, "id");
        try {
            return this.get(this.getBaseUrl() + "jobs/" + this.encodeName(id), JobImpl.class, true);
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    protected void checkJobNotFound(OperationException e) throws JobNotFoundException {
        ServerExceptionData data = e.getServerExceptionData();
        if (data != null && JobNotFoundException.class.getName().equals(data.getExceptionclass())) {
            String jobid = "?";
            if (data.getParameters().size() > 0) {
                jobid = data.getParameters().get(0);
            }
            JobMessageCodes.AKCJC5101E_JOB_NOT_FOUND_EXCEPTION.log(jobid);
            throw new JobNotFoundException(jobid, e);
        }
    }

    private void checkAttNotFound(OperationException e) throws AttachmentNotFoundException {
        ServerExceptionData data = e.getServerExceptionData();
        if (data != null && AttachmentNotFoundException.class.getName().equals(data.getExceptionclass())) {
            String jobid = "?";
            if (data.getParameters().size() > 0) {
                jobid = data.getParameters().get(0);
            }
            String attid = "?";
            if (data.getParameters().size() > 1) {
                attid = data.getParameters().get(1);
            }
            JobMessageCodes.AKCJC5102E_ATTACHMENT_NOT_FOUND_EXCEPTION.log(jobid, attid);
            throw new AttachmentNotFoundException(jobid, attid, e);
        }
    }

    private void checkSubscription(OperationException e) throws SubscriptionException {
        ServerExceptionData data = e.getServerExceptionData();
        if (data == null) {
            return;
        }
        if (JobLimitException.class.getName().equals(data.getExceptionclass())) {
            JobMessageCodes.AKCJC5111E_JOB_LIMIT_EXCEPTION.log(data.getParameters().toArray());
            throw new JobLimitException(data.getParameters().toArray(), e);
        }
        if (AttachmentStorageLimitException.class.getName().equals(data.getExceptionclass())) {
            JobMessageCodes.AKCJC5112E_ATTACHMENT_STORAGE_LIMIT_EXCEPTION.log(data.getParameters().toArray());
            throw new AttachmentStorageLimitException(data.getParameters().toArray(), e);
        }
        if (StorageLimitException.class.getName().equals(data.getExceptionclass())) {
            JobMessageCodes.AKCJC5113E_STORAGE_LIMIT_EXCEPTION.log(data.getParameters().toArray());
            throw new StorageLimitException(data.getParameters().toArray(), e);
        }
    }

    private void checkValidation(OperationException e) throws ValidationException {
        ServerExceptionData data = e.getServerExceptionData();
        if (data == null) {
            return;
        }
        if (UndefinedApplicationException.class.getName().equals(data.getExceptionclass())) {
            JobMessageCodes.AKCJC5120E_UNDEFINED_APPLICATION_EXCEPTION.log(data.getParameters().toArray());
            throw new UndefinedApplicationException(data.getParameters().toArray(), e);
        }
        if (InvalidApplicationException.class.getName().equals(data.getExceptionclass())) {
            JobMessageCodes.AKCJC5121E_INVALID_APPLICATION_EXCEPTION.log(data.getParameters().toArray());
            throw new InvalidApplicationException(data.getParameters().toArray(), e);
        }
        if (InvalidAttachmentsException.class.getName().equals(data.getExceptionclass())) {
            JobMessageCodes.AKCJC5122E_INVALID_ATTACHMENTS_EXCEPTION.log(data.getParameters().toArray());
            throw new InvalidAttachmentsException(data.getParameters().toArray(), e);
        }
        if (MissingAttachmentsException.class.getName().equals(data.getExceptionclass())) {
            JobMessageCodes.AKCJC5123E_MISSING_ATTACHMENTS_EXCEPTION.log(data.getParameters().toArray());
            throw new MissingAttachmentsException(data.getParameters().toArray(), e);
        }
        if (UnrecognizedAttachmentsException.class.getName().equals(data.getExceptionclass())) {
            JobMessageCodes.AKCJC5124E_UNRECOGNIZED_ATTACHMENTS_EXCEPTION.log(data.getParameters().toArray());
            throw new UnrecognizedAttachmentsException(data.getParameters().toArray(), e);
        }
        if (IllegalJobStatusException.class.getName().equals(data.getExceptionclass())) {
            JobMessageCodes.AKCJC5126E_JOB_STATUS_EXCEPTION.log(data.getParameters().toArray());
            throw new IllegalJobStatusException(data.getParameters().toArray(), e);
        }
        if (FormatNotSupportedException.class.getName().equals(data.getExceptionclass())) {
            JobMessageCodes.AKCJC5128E_FORMAT_NOT_SUPPORTED_EXCEPTION.log(data.getParameters().toArray());
            throw new FormatNotSupportedException(data.getParameters().toArray(), e);
        }
        if (InvalidAttachmentNameException.class.getName().equals(data.getExceptionclass())) {
            JobMessageCodes.AKCJC5129E_INVALID_ATTACHMENT_NAME_EXCEPTION.log(data.getParameters().toArray());
            throw new InvalidAttachmentNameException(data.getParameters().toArray(), e);
        }
        if (EmptyAttachmentException.class.getName().equals(data.getExceptionclass())) {
            JobMessageCodes.AKCJC5130E_EMPTY_ATTACHMENT_EXCEPTION.log(data.getParameters().toArray());
            throw new EmptyAttachmentException(data.getParameters().toArray(), e);
        }
    }

    @Override
    public boolean deleteJob(String id) throws OperationException {
        Validate.notNull(id, "id");
        DeletionStatus status = this.deleteWithStatus(this.getBaseUrl() + "jobs/" + this.encodeName(id));
        if (status.equals((Object)DeletionStatus.DELETED)) {
            JobMessageCodes.AKCJC5213I_JOB_DELETED.log(id);
        }
        return status.equals((Object)DeletionStatus.DELETED);
    }

    @Override
    public JobExecutionStatus getJobExecutionStatus(String id) throws OperationException, JobNotFoundException {
        Validate.notNull(id, "id");
        try {
            JobStatus status = this.get(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/execute", JobStatusImpl.class, true);
            return status == null ? null : status.getExecutionStatus();
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    @Override
    public void executeJob(String id) throws OperationException, JobNotFoundException, SubscriptionException, ValidationException {
        Validate.notNull(id, "id");
        try {
            this.post(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/execute", null);
            JobMessageCodes.AKCJC5203I_JOB_SUBMITTED.log(id);
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            this.checkSubscription(e);
            this.checkValidation(e);
            throw e;
        }
    }

    @Override
    public void abortJob(String id) throws OperationException, JobNotFoundException {
        Validate.notNull(id, "id");
        try {
            this.delete(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/execute");
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    @Override
    public void killJob(String id) throws OperationException, JobNotFoundException {
        Validate.notNull(id, "id");
        try {
            this.delete(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/execute?kill=true");
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    public List<JobAttachmentImpl> getJobAttachments(String id) throws OperationException, JobNotFoundException {
        Validate.notNull(id, "id");
        try {
            return this.getList(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments", new TypeReference<List<JobAttachmentImpl>>(){});
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    public List<JobAttachmentImpl> getJobAttachments(String id, JobAttachmentType type) throws OperationException, JobNotFoundException {
        Validate.notNull(id, "id");
        Validate.notNull(type, "type");
        try {
            String uri = this.buildURI(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments", "type", type.name());
            return this.getList(uri, new TypeReference<List<JobAttachmentImpl>>(){});
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    @Override
    public void deleteJobAttachments(String id) throws OperationException, JobNotFoundException {
        Validate.notNull(id, "id");
        try {
            this.delete(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments");
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    @Override
    public String createJobAttachment(String id, JobAttachmentCreationData att) throws OperationException, JobNotFoundException, SubscriptionException, ValidationException {
        Validate.notNull(id, "id");
        Validate.notNull(att, "data");
        try {
            return this.create(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments", att);
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            this.checkSubscription(e);
            this.checkValidation(e);
            throw e;
        }
    }

    @Override
    public JobAttachmentImpl getJobAttachment(String id, String attid) throws OperationException, JobNotFoundException, AttachmentNotFoundException {
        Validate.notNull(id, "id");
        Validate.notNull(attid, "attid");
        try {
            return this.get(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments/" + this.encodeName(attid), JobAttachmentImpl.class, true);
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            this.checkAttNotFound(e);
            throw e;
        }
    }

    @Override
    public boolean deleteJobAttachment(String id, String attid) throws OperationException, JobNotFoundException {
        Validate.notNull(id, "id");
        Validate.notNull(attid, "attid");
        try {
            DeletionStatus status = this.deleteWithStatus(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments/" + this.encodeName(attid));
            return status.equals((Object)DeletionStatus.DELETED);
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    @Override
    public void uploadJobAttachment(String id, String attid, File archive) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException, SubscriptionException {
        Validate.notNull(id, "id");
        Validate.notNull(attid, "attid");
        Validate.notNull(archive, "file");
        try {
            long start = System.currentTimeMillis();
            JobMessageCodes.AKCJC5208F_ATTACHMENT_UPLOADING.log(id, attid);
            this.putFile(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments/" + this.encodeName(attid) + "/blob", archive);
            JobMessageCodes.AKCJC5202I_ATTACHMENT_UPLOADED.log(id, attid, System.currentTimeMillis() - start);
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            this.checkAttNotFound(e);
            this.checkSubscription(e);
            throw e;
        }
    }

    protected String encodeName(Object key) {
        String encodedKey = null;
        try {
            encodedKey = URLEncoder.encode(key.toString(), "UTF-8");
            encodedKey = encodedKey.replace("+", "%20");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return encodedKey;
    }

    @Override
    public void uploadJobAttachment(String id, String attid, InputStream archive) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException, SubscriptionException {
        Validate.notNull(id, "id");
        Validate.notNull(attid, "attid");
        Validate.notNull(archive, "stream");
        try {
            long start = System.currentTimeMillis();
            JobMessageCodes.AKCJC5208F_ATTACHMENT_UPLOADING.log(id, attid);
            this.putStream(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments/" + this.encodeName(attid) + "/blob", archive);
            JobMessageCodes.AKCJC5202I_ATTACHMENT_UPLOADED.log(id, attid, System.currentTimeMillis() - start);
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            this.checkAttNotFound(e);
            this.checkSubscription(e);
            throw e;
        }
    }

    @Override
    public void uploadJobAttachment(String id, String attid, ObjectMapper mapper, Object obj) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException, SubscriptionException {
        Validate.notNull(id, "id");
        Validate.notNull(attid, "attid");
        Validate.notNull(mapper, "mapper");
        Validate.notNull(obj, "obj");
        try {
            long start = System.currentTimeMillis();
            JobMessageCodes.AKCJC5208F_ATTACHMENT_UPLOADING.log(id, attid);
            this.putStream(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments/" + this.encodeName(attid) + "/blob", mapper, obj);
            JobMessageCodes.AKCJC5202I_ATTACHMENT_UPLOADED.log(id, attid, System.currentTimeMillis() - start);
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            this.checkAttNotFound(e);
            this.checkSubscription(e);
            throw e;
        }
    }

    @Override
    public void downloadJobAttachment(String id, String attid, File archive) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException {
        Validate.notNull(id, "id");
        Validate.notNull(attid, "attid");
        Validate.notNull(archive, "file");
        try {
            long start = System.currentTimeMillis();
            JobMessageCodes.AKCJC5209F_ATTACHMENT_DOWNLOADING.log(id, attid);
            this.getFile(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments/" + this.encodeName(attid) + "/blob", archive);
            JobMessageCodes.AKCJC5210I_ATTACHMENT_DOWNLOADED.log(id, attid, System.currentTimeMillis() - start);
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            this.checkAttNotFound(e);
            throw e;
        }
    }

    @Override
    public void downloadJobAttachment(String id, String attid, OutputStream stream) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException {
        Validate.notNull(id, "id");
        Validate.notNull(attid, "attid");
        Validate.notNull(stream, "stream");
        try {
            long start = System.currentTimeMillis();
            JobMessageCodes.AKCJC5209F_ATTACHMENT_DOWNLOADING.log(id, attid);
            this.getStream(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments/" + this.encodeName(attid) + "/blob", stream);
            JobMessageCodes.AKCJC5210I_ATTACHMENT_DOWNLOADED.log(id, attid, System.currentTimeMillis() - start);
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            this.checkAttNotFound(e);
            throw e;
        }
    }

    @Override
    public InputStream downloadJobAttachment(String id, String attid) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException {
        Validate.notNull(id, "id");
        Validate.notNull(attid, "attid");
        try {
            JobMessageCodes.AKCJC5209F_ATTACHMENT_DOWNLOADING.log(id, attid);
            return this.getStream(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments/" + this.encodeName(attid) + "/blob");
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            this.checkAttNotFound(e);
            throw e;
        }
    }

    @Override
    public <T> T downloadJobAttachment(String id, String attid, ObjectMapper mapper, TypeReference<T> type) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException {
        Validate.notNull(id, "id");
        Validate.notNull(attid, "attid");
        Validate.notNull(mapper, "mapper");
        Validate.notNull(type, "type");
        try {
            long start = System.currentTimeMillis();
            JobMessageCodes.AKCJC5209F_ATTACHMENT_DOWNLOADING.log(id, attid);
            T res = this.getStream(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments/" + this.encodeName(attid) + "/blob", mapper, type);
            JobMessageCodes.AKCJC5210I_ATTACHMENT_DOWNLOADED.log(id, attid, System.currentTimeMillis() - start);
            return res;
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            this.checkAttNotFound(e);
            throw e;
        }
    }

    @Override
    public <T> T downloadJobAttachment(String id, String attid, ObjectMapper mapper, Class<T> type) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException {
        Validate.notNull(id, "id");
        Validate.notNull(attid, "attid");
        Validate.notNull(mapper, "mapper");
        Validate.notNull(type, "type");
        try {
            long start = System.currentTimeMillis();
            JobMessageCodes.AKCJC5209F_ATTACHMENT_DOWNLOADING.log(id, attid);
            T res = this.getStream(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments/" + this.encodeName(attid) + "/blob", mapper, type);
            JobMessageCodes.AKCJC5210I_ATTACHMENT_DOWNLOADED.log(id, attid, System.currentTimeMillis() - start);
            return res;
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            this.checkAttNotFound(e);
            throw e;
        }
    }

    @Override
    public void downloadLog(String id, File archive) throws IOException, OperationException, JobNotFoundException {
        Validate.notNull(id, "id");
        Validate.notNull(archive, "file");
        try {
            long start = System.currentTimeMillis();
            JobMessageCodes.AKCJC5211F_LOG_DOWNLOADING.log(id);
            this.getFile(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/log/blob", archive);
            JobMessageCodes.AKCJC5212I_LOG_DOWNLOADED.log(id, System.currentTimeMillis() - start);
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    @Override
    public void downloadLog(String id, OutputStream stream) throws IOException, OperationException, JobNotFoundException {
        Validate.notNull(id, "id");
        Validate.notNull(stream, "stream");
        try {
            long start = System.currentTimeMillis();
            JobMessageCodes.AKCJC5211F_LOG_DOWNLOADING.log(id);
            this.getStream(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/log/blob", stream);
            JobMessageCodes.AKCJC5212I_LOG_DOWNLOADED.log(id, System.currentTimeMillis() - start);
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    @Override
    public InputStream downloadLog(String id) throws IOException, OperationException, JobNotFoundException {
        Validate.notNull(id, "id");
        try {
            JobMessageCodes.AKCJC5211F_LOG_DOWNLOADING.log(id);
            return this.getStream(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/log/blob");
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    @Override
    public JobFailureInfo getFailureInfo(String id) throws OperationException, JobNotFoundException {
        Validate.notNull(id, "id");
        try {
            return this.get(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/failure", JobFailureInfoImpl.class, false);
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    public List<JobLogItemImpl> getJobLogItems(String jobid) throws OperationException, JobNotFoundException {
        Validate.notNull(jobid, "id");
        try {
            return this.getList(this.getBaseUrl() + "jobs/" + this.encodeName(jobid) + "/log/items", new TypeReference<List<JobLogItemImpl>>(){});
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    public List<JobLogItemImpl> getJobLogItems(String jobid, long start) throws OperationException, JobNotFoundException {
        Validate.notNull(jobid, "id");
        try {
            String uri = this.buildURI(this.getBaseUrl() + "jobs/" + this.encodeName(jobid) + "/log/items", "start", Long.toString(start));
            return this.getList(uri, new TypeReference<List<JobLogItemImpl>>(){});
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    @Override
    public List<? extends JobLogItem> getJobLogItems(String jobid, long start, boolean continuous) throws OperationException, JobNotFoundException {
        Validate.notNull(jobid, "id");
        try {
            String uri = this.buildURI(this.getBaseUrl() + "jobs/" + this.encodeName(jobid) + "/log/items", "start", Long.toString(start), "continuous", continuous);
            return this.getList(uri, new TypeReference<List<JobLogItemImpl>>(){});
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            throw e;
        }
    }

    @Override
    public JobCreationDataImpl newJobCreationData() {
        return new JobCreationDataImpl();
    }

    @Override
    public JobAttachmentImpl newInputJobAttachment(String name) {
        Validate.notNull(name, "name");
        return new JobAttachmentImpl(name);
    }

    @Override
    public JobRequestBuilderImpl newRequest() {
        return new JobRequestBuilderImpl(this);
    }

    protected void putStream(String uri, AttachmentContentWriter entity) throws OperationException {
        HttpPut request = new HttpPut(uri);
        try {
            request.addHeader("Content-Type", "application/octet-stream");
            if (this.compression) {
                request.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new InternalCustomEntity(entity)));
            } else {
                request.setEntity((HttpEntity)new InternalCustomEntity(entity));
            }
            try (CloseableHttpResponse response = this.execute((HttpUriRequest)request);){
                switch (response.getStatusLine().getStatusCode()) {
                    case 204: {
                        return;
                    }
                }
                this.handleStatus((HttpRequestBase)request, response);
                return;
            }
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationException((HttpUriRequest)request, e);
            return;
        }
    }

    @Override
    public void uploadJobAttachment(String id, String attid, AttachmentContentWriter writer) throws IOException, OperationException, JobNotFoundException, AttachmentNotFoundException, SubscriptionException {
        Validate.notNull(id, "id");
        Validate.notNull(attid, "attid");
        Validate.notNull(writer, "writer");
        try {
            long start = System.currentTimeMillis();
            JobMessageCodes.AKCJC5208F_ATTACHMENT_UPLOADING.log(id, attid);
            this.putStream(this.getBaseUrl() + "jobs/" + this.encodeName(id) + "/attachments/" + this.encodeName(attid) + "/blob", writer);
            JobMessageCodes.AKCJC5202I_ATTACHMENT_UPLOADED.log(id, attid, System.currentTimeMillis() - start);
        }
        catch (OperationException e) {
            this.checkJobNotFound(e);
            this.checkAttNotFound(e);
            this.checkSubscription(e);
            throw e;
        }
    }

    public void dropAll() throws OperationException {
        String uri = this.buildURI(this.getBaseUrl() + "admin/jobs/drop", new Object[0]);
        this.post(uri, null);
    }

    static class InternalCustomEntity
    extends AbstractHttpEntity {
        AttachmentContentWriter entity;

        public InternalCustomEntity(AttachmentContentWriter entity) {
            this.entity = entity;
        }

        public boolean isRepeatable() {
            return this.entity.isRepeatable();
        }

        public long getContentLength() {
            return -1L;
        }

        public boolean isStreaming() {
            return false;
        }

        public InputStream getContent() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream outstream) throws IOException {
            this.entity.writeTo(outstream);
        }
    }
}

