/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.job.impl;

import com.ibm.icu.text.DateFormat;
import com.ibm.optim.oaas.client.OaasException;
import com.ibm.optim.oaas.client.OperationException;
import com.ibm.optim.oaas.client.impl.ClientMessageCodes;
import com.ibm.optim.oaas.client.job.AttachmentNotFoundException;
import com.ibm.optim.oaas.client.job.JobCallback;
import com.ibm.optim.oaas.client.job.JobClient;
import com.ibm.optim.oaas.client.job.JobExecutor;
import com.ibm.optim.oaas.client.job.JobInput;
import com.ibm.optim.oaas.client.job.JobNotFoundException;
import com.ibm.optim.oaas.client.job.JobOutput;
import com.ibm.optim.oaas.client.job.JobRequest;
import com.ibm.optim.oaas.client.job.JobResponse;
import com.ibm.optim.oaas.client.job.SubscriptionException;
import com.ibm.optim.oaas.client.job.ValidationException;
import com.ibm.optim.oaas.client.job.impl.JobClientImpl;
import com.ibm.optim.oaas.client.job.impl.JobFileInputImpl;
import com.ibm.optim.oaas.client.job.impl.JobLogOutputImpl;
import com.ibm.optim.oaas.client.job.impl.JobMessageCodes;
import com.ibm.optim.oaas.client.job.impl.JobRequestImpl;
import com.ibm.optim.oaas.client.job.impl.JobResponseImpl;
import com.ibm.optim.oaas.client.job.impl.JobStreamInputImpl;
import com.ibm.optim.oaas.client.job.model.JobAttachmentType;
import com.ibm.optim.oaas.client.job.model.JobCreationData;
import com.ibm.optim.oaas.client.job.model.JobExecutionStatus;
import com.ibm.optim.oaas.client.job.model.JobLogItem;
import com.ibm.optim.oaas.client.job.model.JobLogRecord;
import com.ibm.optim.oaas.client.job.model.impl.JobAttachmentImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobImpl;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class JobExecutorImpl
implements JobExecutor {
    private long timeout;
    private long interval;
    private int retry;
    private long retryDelay;
    private ExecutorService service;

    public JobExecutorImpl(ExecutorService service, long interval, long timeout, int retry, long retryDelay) {
        this.service = service;
        this.interval = interval;
        this.timeout = timeout;
        this.retry = retry;
        this.retryDelay = retryDelay;
    }

    public void start() {
    }

    @Override
    public void shutdown() {
        this.service.shutdown();
    }

    @Override
    public Future<JobResponse> create(JobRequest request, JobCallback callback) throws OperationException, IOException, InterruptedException, SubscriptionException, ValidationException, JobNotFoundException {
        return this.executeMain(request, callback, true, false, false);
    }

    @Override
    public Future<JobResponse> submit(JobRequest request, JobCallback callback) throws OperationException, IOException, InterruptedException, SubscriptionException, ValidationException, JobNotFoundException {
        return this.executeMain(request, callback, true, true, false);
    }

    @Override
    public Future<JobResponse> monitor(JobRequest request, String jobid, JobCallback callback) throws OperationException, IOException, InterruptedException, SubscriptionException, ValidationException, JobNotFoundException {
        JobRequestImpl r = (JobRequestImpl)request;
        r.setJobId(jobid);
        return this.executeMain(r, callback, false, false, true);
    }

    @Override
    public Future<JobResponse> execute(JobRequest request, JobCallback callback) throws OperationException, IOException, InterruptedException, SubscriptionException, ValidationException, JobNotFoundException {
        return this.executeMain(request, callback, true, true, true);
    }

    public Future<JobResponse> executeMain(final JobRequest request, final JobCallback callback, final boolean create, final boolean submit, final boolean monitor) throws OperationException, IOException, InterruptedException, SubscriptionException, ValidationException, JobNotFoundException {
        final JobRequestImpl r = (JobRequestImpl)request;
        Future<JobResponse> result = this.service.submit(new Callable<JobResponse>(){

            @Override
            public JobResponse call() throws Exception {
                JobResponseImpl response = new JobResponseImpl(r.getClient(), r.getData(), r.getOutput(), r.getLogOutput());
                return JobExecutorImpl.this.executeImpl((JobRequestImpl)request, callback, response, create, submit, monitor);
            }
        });
        r.setSubmitted(true);
        return result;
    }

    @Override
    public Future<JobResponse> execute(JobRequest request) throws OperationException, IOException, InterruptedException, SubscriptionException, ValidationException, JobNotFoundException {
        return this.execute(request, null);
    }

    protected String createJob(JobClient client, JobCreationData data) throws SubscriptionException, ValidationException, OperationException {
        RetryLoop loop = new RetryLoop();
        while (loop.shouldRetry()) {
            try {
                return client.createJob(data);
            }
            catch (OperationException e) {
                loop.exception(e);
                loop.next();
            }
        }
        return null;
    }

    protected String batchSubmitJob(JobClientImpl client, JobCreationData data, List<JobInput> inputs) throws SubscriptionException, ValidationException, OperationException {
        Object[] atts = new Object[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            JobInput input = inputs.get(i);
            if (input instanceof JobStreamInputImpl) {
                atts[i] = ((JobStreamInputImpl)input).getInputStream();
                continue;
            }
            if (input instanceof JobFileInputImpl) {
                atts[i] = ((JobFileInputImpl)input).getFile();
                continue;
            }
            throw new IllegalArgumentException("Unsupported JobInput type for '" + input.getName() + "', only File and InputStream attachments are supported in batch mode.");
        }
        return client.submitJob(data, atts);
    }

    protected String copyJob(JobClient client, String jobid, JobCreationData data, boolean shallow) throws SubscriptionException, ValidationException, OperationException, JobNotFoundException {
        RetryLoop loop = new RetryLoop();
        while (loop.shouldRetry()) {
            try {
                return client.copyJob(jobid, data, shallow);
            }
            catch (OperationException e) {
                loop.exception(e);
                loop.next();
            }
        }
        return null;
    }

    protected String recreateJob(JobClient client, String jobid, JobCreationData data) throws SubscriptionException, ValidationException, OperationException, JobNotFoundException {
        RetryLoop loop = new RetryLoop();
        while (loop.shouldRetry()) {
            try {
                return client.recreateJob(jobid, data, false);
            }
            catch (OperationException e) {
                loop.exception(e);
                loop.next();
            }
        }
        return null;
    }

    protected void upload(JobClientImpl client, String jobid, JobInput input) throws JobNotFoundException, AttachmentNotFoundException, SubscriptionException, IOException, OperationException {
        RetryLoop loop = new RetryLoop();
        while (loop.shouldRetry()) {
            try {
                input.upload(client, jobid);
                return;
            }
            catch (OperationException e) {
                loop.exception(e);
                loop.next();
            }
        }
    }

    protected void download(JobClientImpl client, String jobid, JobOutput output) throws JobNotFoundException, AttachmentNotFoundException, SubscriptionException, IOException, OperationException {
        RetryLoop loop = new RetryLoop();
        while (loop.shouldRetry()) {
            try {
                output.download(client, jobid);
                return;
            }
            catch (OperationException e) {
                loop.exception(e);
                loop.next();
            }
        }
    }

    protected void downloadLog(JobClientImpl client, String jobid, JobLogOutputImpl output) throws JobNotFoundException, AttachmentNotFoundException, SubscriptionException, IOException, OperationException {
        RetryLoop loop = new RetryLoop();
        while (loop.shouldRetry()) {
            try {
                output.download(client, jobid);
                return;
            }
            catch (OperationException e) {
                loop.exception(e);
                loop.next();
            }
        }
    }

    protected void submit(JobClientImpl client, String jobid) throws JobNotFoundException, SubscriptionException, ValidationException, OperationException {
        RetryLoop loop = new RetryLoop();
        while (loop.shouldRetry()) {
            try {
                client.executeJob(jobid);
                return;
            }
            catch (OperationException e) {
                loop.exception(e);
                loop.next();
            }
        }
    }

    protected JobImpl getJob(JobClientImpl client, String jobid) throws JobNotFoundException, SubscriptionException, ValidationException, OperationException {
        RetryLoop loop = new RetryLoop();
        while (loop.shouldRetry()) {
            try {
                return client.getJob(jobid);
            }
            catch (OperationException e) {
                loop.exception(e);
                loop.next();
            }
        }
        return null;
    }

    protected void deleteJob(JobClientImpl client, String jobid) throws JobNotFoundException, SubscriptionException, ValidationException, OperationException {
        RetryLoop loop = new RetryLoop();
        while (loop.shouldRetry()) {
            try {
                client.deleteJob(jobid);
                return;
            }
            catch (OperationException e) {
                loop.exception(e);
                loop.next();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JobResponse executeImpl(JobRequestImpl request, JobCallback callback, JobResponseImpl response, boolean create, boolean submit, boolean monitor) throws OaasException, IOException, InterruptedException {
        try {
            JobClientImpl client = request.getClient();
            String jobid = null;
            boolean submitted = false;
            if (create) {
                boolean upload = true;
                try {
                    if (request.getCopyJobId() != null) {
                        jobid = this.copyJob(client, request.getCopyJobId(), request.getData(), request.getShallowCopy());
                    } else if (request.getRecreateJobId() != null) {
                        jobid = this.recreateJob(client, request.getRecreateJobId(), request.getData());
                    } else if (request.isBatchSubmitMode()) {
                        jobid = this.batchSubmitJob(client, request.getData(), request.getInput());
                        submitted = true;
                        submit = false;
                        upload = false;
                    } else {
                        jobid = this.createJob(client, request.getData());
                    }
                }
                finally {
                    request.setJobId(jobid);
                    response.setJobId(request.getJobId());
                    if (jobid != null && callback != null) {
                        callback.created(response);
                    }
                }
                if (upload) {
                    for (JobInput input : request.getInput()) {
                        if (input.isRepeatable()) {
                            this.upload(client, jobid, input);
                            continue;
                        }
                        input.upload(client, jobid);
                    }
                }
            }
            response.setJobId(request.getJobId());
            jobid = request.getJobId();
            if (submit) {
                this.submit(client, jobid);
                submitted = true;
            }
            if (submitted && callback != null) {
                callback.submitted(response);
            }
            if (monitor) {
                this.waitForCompletion(client, request, jobid, request.getTimeout() == 0L ? this.timeout : request.getTimeout(), callback, response);
                JobImpl job = response.getJob();
                JobMessageCodes.AKCJC5215I_JOB_ENDED.log(jobid, job.getSubmittedAt() == null || job.getCreatedAt() == null ? 0L : job.getSubmittedAt().getTime() - job.getCreatedAt().getTime(), job.getStartedAt() == null || job.getSubmittedAt() == null ? 0L : job.getStartedAt().getTime() - job.getSubmittedAt().getTime(), job.getEndedAt() == null || job.getStartedAt() == null ? 0L : job.getEndedAt().getTime() - job.getStartedAt().getTime());
                JobAttachmentImpl result = null;
                for (JobAttachmentImpl jobAttachmentImpl : job.getImplAttachments()) {
                    if (!JobAttachmentType.OUTPUT_ATTACHMENT.equals((Object)jobAttachmentImpl.getType())) continue;
                    result = jobAttachmentImpl;
                    break;
                }
                if (result != null) {
                    for (JobOutput jobOutput : request.getOutput()) {
                        if (jobOutput.getName() == null) {
                            jobOutput.setName(result.getName());
                        }
                        this.download(client, jobid, jobOutput);
                    }
                }
                for (JobLogOutputImpl jobLogOutputImpl : request.getLogOutput()) {
                    this.downloadLog(client, jobid, jobLogOutputImpl);
                }
                if (request.isDeleteOnCompletion()) {
                    this.deleteJob(client, jobid);
                }
                if (callback != null) {
                    callback.completed(response);
                }
            }
            return response;
        }
        catch (Exception e) {
            if (callback != null) {
                callback.exception(response, e);
            }
            throw e;
        }
        catch (Throwable e) {
            JobMessageCodes.AKCJC5302E_INTERNAL_EXCEPTION.log(e, e.getLocalizedMessage());
            throw e;
        }
    }

    private JobExecutionStatus getStatus(JobClient client, String jobid) throws JobNotFoundException {
        try {
            return client.getJobExecutionStatus(jobid);
        }
        catch (OperationException e) {
            return null;
        }
    }

    private List<? extends JobLogItem> getLogItems(JobClient client, String jobid, long start) throws JobNotFoundException {
        try {
            return client.getJobLogItems(jobid, start, true);
        }
        catch (OperationException e) {
            return null;
        }
    }

    protected JobResponseImpl waitForCompletion(JobClientImpl client, JobRequest request, String jobid, long timeout, JobCallback callback, JobResponseImpl response) throws OperationException, InterruptedException, JobNotFoundException, SubscriptionException, ValidationException, IOException {
        long limit = System.currentTimeMillis() + timeout;
        JobExecutionStatus status = this.getStatus(client, jobid);
        boolean running = false;
        long sleepTime = this.interval;
        if (timeout > 0L) {
            sleepTime = Math.min(this.interval, timeout);
        }
        if (request.getLivelog() == null) {
            while (!JobExecutionStatus.isEnded(status)) {
                if (JobExecutionStatus.RUNNING.equals((Object)status) && !running) {
                    running = true;
                    JobMessageCodes.AKCJC5204I_JOB_RUNNING.log(jobid);
                    if (callback != null) {
                        callback.running(response);
                    }
                }
                if (timeout >= 0L && System.currentTimeMillis() > limit) {
                    JobMessageCodes.AKCJC5216W_JOB_MONITORING_TIMEOUT.log(jobid, timeout);
                    throw new InterruptedException(JobMessageCodes.AKCJC5216W_JOB_MONITORING_TIMEOUT.extractMessage(jobid, timeout));
                }
                Thread.sleep(sleepTime);
                status = this.getStatus(client, jobid);
            }
        } else {
            long itemIndex = 0L;
            boolean stop = false;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(request.getLivelog()));
            while (!stop) {
                if (JobExecutionStatus.RUNNING.equals((Object)status) && !running) {
                    running = true;
                    JobMessageCodes.AKCJC5204I_JOB_RUNNING.log(jobid);
                    if (callback != null) {
                        callback.running(response);
                    }
                }
                if (timeout >= 0L && System.currentTimeMillis() > limit) {
                    JobMessageCodes.AKCJC5216W_JOB_MONITORING_TIMEOUT.log(jobid, timeout);
                    throw new InterruptedException(JobMessageCodes.AKCJC5216W_JOB_MONITORING_TIMEOUT.extractMessage(jobid, timeout));
                }
                List<? extends JobLogItem> items = this.getLogItems(client, jobid, itemIndex);
                if (items != null && !items.isEmpty()) {
                    this.formatLogItems(items, writer, request.getLivelogDateFormat());
                    JobLogItem lastItem = items.get(items.size() - 1);
                    itemIndex = lastItem.getSeqid() + 1L;
                    stop = lastItem.stop();
                } else {
                    Thread.sleep(sleepTime);
                }
                if (running) continue;
                status = this.getStatus(client, jobid);
            }
        }
        JobImpl job = this.getJob(client, jobid);
        status = job.getExecutionStatus();
        response.setJob(job);
        if (JobExecutionStatus.PROCESSED.equals((Object)status)) {
            JobMessageCodes.AKCJC5205I_JOB_PROCESSED.log(jobid);
            if (callback != null) {
                callback.processed(response);
            }
        } else if (JobExecutionStatus.FAILED.equals((Object)status)) {
            JobMessageCodes.AKCJC5206I_JOB_FAILED.log(jobid);
            if (callback != null) {
                callback.failed(response);
            }
        } else if (JobExecutionStatus.INTERRUPTED.equals((Object)status) || JobExecutionStatus.INTERRUPTING.equals((Object)status)) {
            JobMessageCodes.AKCJC5207I_JOB_INTERRUPTED.log(jobid);
            if (callback != null) {
                callback.interruption(response);
            }
        }
        return response;
    }

    private void formatLogItems(List<? extends JobLogItem> items, Writer writer, DateFormat format) throws IOException {
        for (JobLogItem jobLogItem : items) {
            if (jobLogItem.missing()) {
                writer.write(JobMessageCodes.AKCJC5241I_LOG_ITEM_NOT_AVAILABLE.extractMessage(jobLogItem.getSeqid()));
                writer.write("\n");
                continue;
            }
            for (JobLogRecord record : jobLogItem.getEngineLogRecords()) {
                writer.write("[");
                if (format != null) {
                    writer.write(format.format(record.getDate()));
                } else {
                    writer.write(record.getDate().toString());
                }
                writer.write(", ");
                writer.write(record.getLevel().length() > 4 ? record.getLevel().substring(0, 4) : record.getLevel());
                writer.write("] ");
                writer.write(this.stripCRLF(record.getMessage()));
                writer.write("\r\n");
            }
        }
        writer.flush();
    }

    private String stripCRLF(String text) {
        while (text.endsWith("\r") || text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    static /* synthetic */ long access$000(JobExecutorImpl x0) {
        return x0.retryDelay;
    }

    class RetryLoop {
        int _count = 1;
        long delay = JobExecutorImpl.access$000(JobExecutorImpl.this);

        boolean shouldRetry() {
            return this._count <= JobExecutorImpl.this.retry;
        }

        public void next() {
            ++this._count;
        }

        public void exception(OperationException e) throws OperationException {
            if (this._count == JobExecutorImpl.this.retry) {
                throw e;
            }
            if (e.getCode() == 0 && e.getCause() != null) {
                ClientMessageCodes.AKCJC5006I_RETRY_OPERATION_CAUSE_EXCEPTION.log(e.getCause().getLocalizedMessage(), e.getOperation(), e.getURI(), this._count);
            } else {
                ClientMessageCodes.AKCJC5003I_RETRY_OPERATION_EXCEPTION.log(e.getCode(), e.getOperation(), e.getURI(), this._count);
            }
            try {
                Thread.sleep(this.delay);
                this.delay *= 2L;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

